/*
 * Decompiled with CFR 0.152.
 */
package kr.jclab.javautils.sipc.bson.entity;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import kr.jclab.javautils.sipc.bson.entity.ConnectInfo;
import org.bson.codecs.pojo.annotations.BsonCreator;
import org.bson.codecs.pojo.annotations.BsonProperty;

public class TcpConnectInfo
extends ConnectInfo {
    public static final String CHANNEL_TYPE_TCP4 = "tcp4";
    public static final String CHANNEL_TYPE_TCP6 = "tcp6";
    public static final Set<String> CHANNEL_TYPES = Collections.unmodifiableSet(new HashSet<String>(){
        {
            this.add(TcpConnectInfo.CHANNEL_TYPE_TCP4);
            this.add(TcpConnectInfo.CHANNEL_TYPE_TCP6);
        }
    });
    @BsonProperty(value="address")
    private final String address;
    @BsonProperty(value="port")
    private final int port;

    @BsonCreator
    public TcpConnectInfo(@BsonProperty(value="channel_id") String channelId, @BsonProperty(value="channel_type") String channelType, @BsonProperty(value="algo") String algo, @BsonProperty(value="public_key") byte[] publicKey, @BsonProperty(value="address") String address, @BsonProperty(value="port") int port) {
        super(channelId, channelType, algo, publicKey);
        this.address = address;
        this.port = port;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getAddress() {
        return this.address;
    }

    public int getPort() {
        return this.port;
    }

    @Override
    public String toString() {
        return "TcpConnectInfo(address=" + this.getAddress() + ", port=" + this.getPort() + ")";
    }

    public static class Builder {
        private String channelId;
        private String channelType;
        private String algo;
        private byte[] publicKey;
        private String address;
        private int port;

        Builder() {
        }

        public Builder channelId(String channelId) {
            this.channelId = channelId;
            return this;
        }

        public Builder channelType(String channelType) {
            this.channelType = channelType;
            return this;
        }

        public Builder algo(String algo) {
            this.algo = algo;
            return this;
        }

        public Builder publicKey(byte[] publicKey) {
            this.publicKey = publicKey;
            return this;
        }

        public Builder address(String address) {
            this.address = address;
            return this;
        }

        public Builder port(int port) {
            this.port = port;
            return this;
        }

        public TcpConnectInfo build() {
            return new TcpConnectInfo(this.channelId, this.channelType, this.algo, this.publicKey, this.address, this.port);
        }

        public String toString() {
            return "TcpConnectInfo.Builder(channelId=" + this.channelId + ", channelType=" + this.channelType + ", algo=" + this.algo + ", publicKey=" + Arrays.toString(this.publicKey) + ", address=" + this.address + ", port=" + this.port + ")";
        }
    }
}

