/*
 * Decompiled with CFR 0.152.
 */
package kr.jclab.javautils.sipc.channel;

import com.google.common.annotations.VisibleForTesting;
import com.google.protobuf.ByteString;
import com.google.protobuf.GeneratedMessageV3;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.Mac;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import kr.jclab.javautils.sipc.ProtoMessageHouse;
import kr.jclab.javautils.sipc.SecurityProviderHolder;
import kr.jclab.javautils.sipc.channel.CleanupHandler;
import kr.jclab.javautils.sipc.channel.ClientContext;
import kr.jclab.javautils.sipc.channel.IpcChannel;
import kr.jclab.javautils.sipc.channel.IpcChannelListener;
import kr.jclab.javautils.sipc.channel.IpcChannelStatus;
import kr.jclab.javautils.sipc.channel.WrappedDataReceiver;
import kr.jclab.javautils.sipc.crypto.CryptoException;
import kr.jclab.javautils.sipc.crypto.EphemeralKeyPair;
import kr.jclab.sipc.common.proto.Frames;

public abstract class AbstractIpcChannel
implements IpcChannel {
    protected byte[] serverNonce = null;
    protected byte[] clientNonce = null;
    protected final String channelId;
    protected final IpcChannelListener ipcChannelListener;
    protected final EphemeralKeyPair myKey;
    protected ClientContext clientContext = null;
    protected long myCounter = 0L;
    protected long peerCounter = 0L;
    private byte[] sharedMasterSecret = null;
    private IpcChannelStatus ipcChannelStatus = IpcChannelStatus.Idle;
    private final List<CleanupHandler> cleanupHandlers = new ArrayList<CleanupHandler>();
    private final Map<String, WrappedDataReceiverHolder<?>> wrappedDataReceivers = new HashMap();

    protected AbstractIpcChannel(String channelId, IpcChannelListener ipcChannelListener, EphemeralKeyPair myKey) {
        this.channelId = channelId;
        this.ipcChannelListener = ipcChannelListener;
        this.myKey = myKey;
    }

    @Override
    public void attachClientContext(ClientContext clientContext) {
        this.clientContext = clientContext;
        this.myCounter = 0L;
        this.peerCounter = 0L;
    }

    @Override
    public IpcChannelStatus getChannelStatus() {
        return this.ipcChannelStatus;
    }

    private void updateChannelStatus(IpcChannelStatus status) {
        this.ipcChannelStatus = status;
        this.ipcChannelListener.onChangeChannelStatus(status);
    }

    @Override
    public String getChannelId() {
        return this.channelId;
    }

    @Override
    public void sendFrame(GeneratedMessageV3 frame) throws IOException {
        if (this.clientContext == null) {
            throw new IOException("Not Ready ClientContext");
        }
        this.clientContext.sendFrame(frame);
    }

    @Override
    public void onAlertFrame(Frames.AlertFrame frame) throws IOException {
        System.out.println("onAlertFrame : " + frame);
    }

    @Override
    public void onServerHello(Frames.ServerHelloFrame frame) throws IOException {
    }

    @Override
    public void onClientHello(Frames.ClientHelloFrame frame) throws IOException {
        try {
            this.clientNonce = frame.getClientNonce().toByteArray();
            this.serverNonce = new byte[32];
            SecurityProviderHolder.SECURE_RANDOM.nextBytes(this.serverNonce);
            byte[] ecdhDerivedSecret = this.myKey.derive(frame.getEphemeralPublicKey().toByteArray());
            Mac mac = Mac.getInstance("HmacSHA256");
            mac.init(new SecretKeySpec(ecdhDerivedSecret, "HMAC"));
            mac.update(this.serverNonce);
            mac.update(this.clientNonce);
            this.sharedMasterSecret = mac.doFinal();
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | CryptoException e) {
            this.updateChannelStatus(IpcChannelStatus.Error);
            throw new IOException(e);
        }
        Frames.ServerHelloEncrpytedData encryptedData = Frames.ServerHelloEncrpytedData.newBuilder().setVersion(1).build();
        Frames.ServerHelloFrame serverHelloFrame = Frames.ServerHelloFrame.newBuilder().setVersion(1).setServerNonce(ByteString.copyFrom((byte[])this.serverNonce)).setEncryptedData(this.wrapDataToSend(encryptedData.toByteArray())).build();
        this.sendFrame(serverHelloFrame);
        this.updateChannelStatus(IpcChannelStatus.Established);
    }

    @Override
    public void onWrappedData(Frames.EncryptedWrappedData frame) throws IOException {
        Frames.WrappedData wrappedData = this.unwrapDataToRecv(frame);
        WrappedDataReceiverHolder<?> receiver = this.wrappedDataReceivers.get(wrappedData.getMessage().getTypeUrl());
        if (receiver == null) {
            System.err.println("receiver is null : " + wrappedData.getMessage().getTypeUrl());
            return;
        }
        GeneratedMessageV3 decodedMessage = (GeneratedMessageV3)receiver.messageDefaultInstance.newBuilderForType().mergeFrom(wrappedData.getMessage().getValue()).build();
        receiver.receiver.onMessage(wrappedData, decodedMessage);
    }

    @Override
    public void onCleanup() {
        boolean hasException = false;
        RuntimeException exception = new RuntimeException("exceptions");
        for (CleanupHandler handler : this.cleanupHandlers) {
            try {
                handler.cleanup();
            }
            catch (Throwable e) {
                hasException = true;
                exception.addSuppressed(e);
            }
        }
        if (hasException) {
            throw exception;
        }
    }

    @Override
    public void sendWrappedData(Frames.WrappedData wrappedData) throws IOException {
        Frames.EncryptedWrappedData encryptedWrappedData = this.wrapDataToSend(wrappedData.toByteArray());
        this.sendFrame(encryptedWrappedData);
    }

    public byte[] generateSecret(String type, long counter, int size) {
        ByteBuffer buffer = ByteBuffer.allocate(type.length() + 8).order(ByteOrder.LITTLE_ENDIAN).put(type.getBytes(StandardCharsets.UTF_8)).putLong(counter);
        buffer.flip();
        try {
            Mac mac = Mac.getInstance("HmacSHA256");
            mac.init(new SecretKeySpec(this.sharedMasterSecret, "HMAC"));
            mac.update(buffer);
            byte[] output = mac.doFinal();
            if (output.length > size) {
                return Arrays.copyOfRange(output, 0, size);
            }
            return output;
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public Frames.EncryptedWrappedData wrapDataToSend(byte[] data) {
        long counter = this.myCounter++;
        byte[] iv = this.generateSecret("siv", counter, 16);
        byte[] key = this.generateSecret("sky", counter, 32);
        GCMParameterSpec gcmParameterSpec = new GCMParameterSpec(128, iv);
        try {
            Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
            cipher.init(1, (Key)new SecretKeySpec(key, "AES"), gcmParameterSpec);
            byte[] cipherText = cipher.doFinal(data);
            int authTagPos = cipherText.length - gcmParameterSpec.getTLen() / 8;
            byte[] authTag = Arrays.copyOfRange(cipherText, authTagPos, cipherText.length);
            return Frames.EncryptedWrappedData.newBuilder().setVersion(1).setCipherText(ByteString.copyFrom((byte[])cipherText, (int)0, (int)authTagPos)).setAuthTag(ByteString.copyFrom((byte[])authTag)).build();
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw new RuntimeException(e);
        }
    }

    public static void safeOutputStreamWrite(OutputStream outputStream, byte[] data) throws IOException {
        if (data != null) {
            outputStream.write(data);
        }
    }

    public Frames.WrappedData unwrapDataToRecv(Frames.EncryptedWrappedData wrappedData) {
        long counter = this.peerCounter++;
        byte[] iv = this.generateSecret("civ", counter, 16);
        byte[] key = this.generateSecret("cky", counter, 32);
        GCMParameterSpec gcmParameterSpec = new GCMParameterSpec(128, iv);
        try {
            Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
            cipher.init(2, (Key)new SecretKeySpec(key, "AES"), gcmParameterSpec);
            ByteArrayOutputStream bos = new ByteArrayOutputStream(wrappedData.getCipherText().size());
            AbstractIpcChannel.safeOutputStreamWrite(bos, cipher.update(wrappedData.getCipherText().toByteArray()));
            AbstractIpcChannel.safeOutputStreamWrite(bos, cipher.doFinal(wrappedData.getAuthTag().toByteArray()));
            return Frames.WrappedData.parseFrom(bos.toByteArray());
        }
        catch (IOException | InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <T extends GeneratedMessageV3> void registerWrappedData(T messageDefaultInstance, WrappedDataReceiver<T> receiver) {
        String typeUrl = ProtoMessageHouse.getTypeUrl(messageDefaultInstance);
        this.wrappedDataReceivers.compute(typeUrl, (k, old) -> {
            if (old != null) {
                throw new IllegalArgumentException("Duplicated type url");
            }
            return new WrappedDataReceiverHolder(messageDefaultInstance, receiver);
        });
    }

    @Override
    public void addCleanupHandler(CleanupHandler cleanupHandler) {
        this.cleanupHandlers.add(cleanupHandler);
    }

    @VisibleForTesting
    private static class WrappedDataReceiverHolder<T extends GeneratedMessageV3> {
        public final GeneratedMessageV3 messageDefaultInstance;
        public final WrappedDataReceiver<T> receiver;

        public WrappedDataReceiverHolder(GeneratedMessageV3 messageDefaultInstance, WrappedDataReceiver<T> receiver) {
            this.messageDefaultInstance = messageDefaultInstance;
            this.receiver = receiver;
        }
    }
}

