/*
 * Decompiled with CFR 0.152.
 */
package kr.jclab.javautils.sipc.channel;

import com.google.common.annotations.VisibleForTesting;
import com.google.protobuf.GeneratedMessageV3;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.concurrent.atomic.AtomicReference;
import kr.jclab.javautils.sipc.channel.FrameConverter;
import kr.jclab.sipc.common.proto.Frames;

public abstract class ClientContext {
    protected final ByteBuffer receivingBuffer = ByteBuffer.allocate(0x1000000).order(ByteOrder.LITTLE_ENDIAN);
    private final AtomicReference<FrameConverter.FrameHandlers> frameHandlers;
    private final FrameConverter.FrameHandlers preRoutedFrameHandlers = new FrameConverter.FrameHandlers(){

        @Override
        public void onAlertFrame(Frames.AlertFrame frame) throws IOException {
            throw new IOException("Illegal State");
        }

        @Override
        public void onServerHello(Frames.ServerHelloFrame frame) throws IOException {
            throw new IOException("Illegal State");
        }

        @Override
        public void onClientHello(Frames.ClientHelloFrame frame) throws IOException {
            ClientContext.this.recvDecideRoute(frame.getChannelId());
            FrameConverter.FrameHandlers newFrameHandlers = (FrameConverter.FrameHandlers)ClientContext.this.frameHandlers.get();
            if (newFrameHandlers != ClientContext.this.preRoutedFrameHandlers) {
                newFrameHandlers.onClientHello(frame);
                return;
            }
            throw new IOException("Illegal State");
        }

        @Override
        public void onWrappedData(Frames.EncryptedWrappedData frame) throws IOException {
            throw new IOException("Illegal State");
        }

        @Override
        public void onCleanup() {
        }
    };

    public ClientContext() {
        this.receivingBuffer.clear();
        this.frameHandlers = new AtomicReference<FrameConverter.FrameHandlers>(this.preRoutedFrameHandlers);
    }

    public void cleanup() {
        this.frameHandlers.get().onCleanup();
    }

    protected void recvAfterReadRaw() throws IOException {
        boolean hasNextPacket;
        do {
            int frameSize;
            hasNextPacket = false;
            int availableLength = this.receivingBuffer.position();
            if (availableLength < 4 || availableLength < (frameSize = FrameConverter.toInt24(this.receivingBuffer.getInt(0)))) continue;
            this.receivingBuffer.flip();
            this.processFrame(this.receivingBuffer, frameSize);
            if (this.receivingBuffer.remaining() > 0) {
                byte[] temp = new byte[this.receivingBuffer.remaining()];
                this.receivingBuffer.get(temp);
                this.receivingBuffer.clear();
                this.receivingBuffer.put(temp);
                hasNextPacket = true;
                continue;
            }
            this.receivingBuffer.clear();
        } while (hasNextPacket);
    }

    private void processFrame(ByteBuffer buffer, int frameSize) throws IOException {
        this.receivingBuffer.get();
        this.receivingBuffer.get();
        this.receivingBuffer.get();
        byte frameType = this.receivingBuffer.get();
        byte[] payload = new byte[frameSize - 4];
        buffer.get(payload);
        try {
            FrameConverter.getInstance().parse(this.frameHandlers.get(), frameType, payload);
        }
        catch (Throwable e) {
            throw new IOException(e);
        }
    }

    protected void recvSetFrameHandlers(FrameConverter.FrameHandlers frameHandlers) {
        this.frameHandlers.set(frameHandlers);
    }

    protected abstract void recvDecideRoute(String var1);

    protected abstract void sendRaw(byte[] var1) throws IOException;

    @VisibleForTesting
    public void sendFrame(GeneratedMessageV3 message) throws IOException {
        byte frameType = FrameConverter.getInstance().getFrameType(message);
        int serializedSize = message.getSerializedSize();
        ByteArrayOutputStream bos = new ByteArrayOutputStream(4 + serializedSize);
        ByteBuffer buffer = ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN);
        FrameConverter.writeInt24(buffer, 4 + serializedSize);
        buffer.put(frameType);
        buffer.flip();
        bos.write(buffer.array(), buffer.arrayOffset(), buffer.remaining());
        message.writeTo((OutputStream)bos);
        this.sendRaw(bos.toByteArray());
    }
}

