/*
 * Decompiled with CFR 0.152.
 */
package kr.jclab.javautils.sipc.channel;

import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.InvalidProtocolBufferException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import kr.jclab.sipc.common.proto.Frames;

public class FrameConverter {
    private final Map<Byte, FrameHandlerHolder<?>> handlers;
    private final Map<Class<? extends GeneratedMessageV3>, FrameHandlerHolder<?>> frameTypes;
    private final Method handleMethod;

    public static FrameConverter getInstance() {
        return LazyHolder.INSTANCE;
    }

    public static void add(HashMap<Byte, FrameHandlerHolder<?>> handlers, HashMap<Class<? extends GeneratedMessageV3>, FrameHandlerHolder<?>> frameTypes, FrameHandlerHolder<?> holder) {
        handlers.put(holder.type, holder);
        frameTypes.put(holder.defaultInstance.getClass(), holder);
    }

    public FrameConverter() {
        HashMap handlers = new HashMap();
        HashMap frameTypes = new HashMap();
        try {
            this.handleMethod = FrameHandler.class.getMethod("handle", FrameHandlers.class, Byte.TYPE, GeneratedMessageV3.class);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        FrameConverter.add(handlers, frameTypes, new FrameHandlerHolder<Frames.AlertFrame>(-15, Frames.AlertFrame.getDefaultInstance(), (frameHandlers, frameType, framePayload) -> frameHandlers.onAlertFrame((Frames.AlertFrame)framePayload)));
        FrameConverter.add(handlers, frameTypes, new FrameHandlerHolder<Frames.ClientHelloFrame>(17, Frames.ClientHelloFrame.getDefaultInstance(), (frameHandlers, frameType, framePayload) -> frameHandlers.onClientHello((Frames.ClientHelloFrame)framePayload)));
        FrameConverter.add(handlers, frameTypes, new FrameHandlerHolder<Frames.ServerHelloFrame>(18, Frames.ServerHelloFrame.getDefaultInstance(), (frameHandlers, frameType, framePayload) -> frameHandlers.onServerHello((Frames.ServerHelloFrame)framePayload)));
        FrameConverter.add(handlers, frameTypes, new FrameHandlerHolder<Frames.EncryptedWrappedData>(26, Frames.EncryptedWrappedData.getDefaultInstance(), (frameHandlers, frameType, framePayload) -> frameHandlers.onWrappedData((Frames.EncryptedWrappedData)framePayload)));
        this.handlers = Collections.unmodifiableMap(handlers);
        this.frameTypes = Collections.unmodifiableMap(frameTypes);
    }

    public boolean parse(FrameHandlers frameHandlers, byte frameType, byte[] framePayload) throws InvalidProtocolBufferException {
        FrameHandlerHolder<?> holder = this.handlers.get(frameType);
        if (holder == null) {
            return false;
        }
        GeneratedMessageV3 message = (GeneratedMessageV3)holder.defaultInstance.newBuilderForType().mergeFrom(framePayload).build();
        try {
            this.handleMethod.invoke(holder.handler, frameHandlers, frameType, message);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        return true;
    }

    public <T extends GeneratedMessageV3> Byte getFrameType(T message) {
        FrameHandlerHolder<?> holder = this.frameTypes.get(message.getClass());
        if (holder == null) {
            return null;
        }
        return holder.type;
    }

    public static void writeInt24(ByteBuffer buffer, int v) {
        buffer.put((byte)(v & 0xFF));
        buffer.put((byte)(v >> 8 & 0xFF));
        buffer.put((byte)(v >> 16 & 0xFF));
    }

    public static int toInt24(int v) {
        return v & 0xFFFFFF;
    }

    private static class FrameHandlerHolder<T extends GeneratedMessageV3> {
        public final byte type;
        public final T defaultInstance;
        public final FrameHandler<? extends GeneratedMessageV3> handler;

        public FrameHandlerHolder(byte type, T defaultInstance, FrameHandler<T> handler) {
            this.type = type;
            this.defaultInstance = defaultInstance;
            this.handler = handler;
        }
    }

    public static interface FrameHandlers {
        public void onAlertFrame(Frames.AlertFrame var1) throws IOException;

        public void onServerHello(Frames.ServerHelloFrame var1) throws IOException;

        public void onClientHello(Frames.ClientHelloFrame var1) throws IOException;

        public void onWrappedData(Frames.EncryptedWrappedData var1) throws IOException;

        public void onCleanup();
    }

    @FunctionalInterface
    public static interface FrameHandler<T extends GeneratedMessageV3> {
        public void handle(FrameHandlers var1, byte var2, T var3) throws IOException;
    }

    public static class LazyHolder {
        public static FrameConverter INSTANCE = new FrameConverter();
    }
}

