/*
 * Decompiled with CFR 0.152.
 */
package kr.jclab.javautils.sipc.crypto;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kr.jclab.javautils.sipc.crypto.EphemeralKeyAlgorithmFactory;
import kr.jclab.javautils.sipc.crypto.EphemeralKeyPairGenerator;
import kr.jclab.javautils.sipc.crypto.x25519.X25519KeyPairGenerator;

public class DefaultEphemeralKeyAlgorithmsFactory
implements EphemeralKeyAlgorithmFactory {
    private final Map<String, EphemeralKeyPairGenerator> algorithms;

    public static DefaultEphemeralKeyAlgorithmsFactory getInstance() {
        return LazyHolder.INSTANCE;
    }

    private DefaultEphemeralKeyAlgorithmsFactory() {
        final X25519KeyPairGenerator x25519 = new X25519KeyPairGenerator();
        this.algorithms = Collections.unmodifiableMap(new HashMap<String, EphemeralKeyPairGenerator>(){
            {
                this.put(x25519.getAlgorithm(), x25519);
            }
        });
    }

    @Override
    public List<String> getAlgorithms() {
        return new ArrayList<String>(this.algorithms.keySet());
    }

    @Override
    public EphemeralKeyPairGenerator getKeyPairGenerator(String algorithm) {
        return this.algorithms.get(algorithm);
    }

    @Override
    public EphemeralKeyPairGenerator getHostKeyPairGenerator() {
        return this.getKeyPairGenerator("x25519");
    }

    public static class LazyHolder {
        public static final DefaultEphemeralKeyAlgorithmsFactory INSTANCE = new DefaultEphemeralKeyAlgorithmsFactory();
    }
}

