/*
 * Decompiled with CFR 0.152.
 */
package kr.jclab.javautils.sipc.crypto.x25519;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.KeyAgreement;
import kr.jclab.javautils.sipc.SecurityProviderHolder;
import kr.jclab.javautils.sipc.crypto.CryptoException;
import kr.jclab.javautils.sipc.crypto.EphemeralKeyPair;
import org.bouncycastle.jcajce.spec.XDHParameterSpec;

public class X25519KeyPair
implements EphemeralKeyPair {
    public static final String ALGORITHM = "x25519";
    private final String paramSpec = "X25519";
    private final KeyPair keyPair;

    public X25519KeyPair() throws CryptoException {
        try {
            KeyPairGenerator kpg = KeyPairGenerator.getInstance("XDH", SecurityProviderHolder.PROVIDER);
            kpg.initialize((AlgorithmParameterSpec)new XDHParameterSpec(this.paramSpec));
            this.keyPair = kpg.generateKeyPair();
        }
        catch (InvalidAlgorithmParameterException | NoSuchAlgorithmException e) {
            throw new CryptoException(e);
        }
    }

    @Override
    public String getAlgorithm() {
        return ALGORITHM;
    }

    @Override
    public byte[] derive(byte[] publicKeyBinary) throws CryptoException {
        try {
            KeyAgreement ka = KeyAgreement.getInstance("XDH", SecurityProviderHolder.PROVIDER);
            ka.init(this.keyPair.getPrivate());
            KeyFactory pkf = KeyFactory.getInstance("XDH", SecurityProviderHolder.PROVIDER);
            PublicKey publicKey = pkf.generatePublic(new X509EncodedKeySpec(publicKeyBinary));
            ka.doPhase(publicKey, true);
            return ka.generateSecret();
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | InvalidKeySpecException e) {
            throw new CryptoException(e);
        }
    }

    @Override
    public byte[] getPublicKey() {
        return this.keyPair.getPublic().getEncoded();
    }
}

