/*
 * Decompiled with CFR 0.152.
 */
package li.rudin.arduino.api.message;

import java.util.ArrayList;
import java.util.List;
import li.rudin.arduino.api.message.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageParser {
    private static final Logger logger = LoggerFactory.getLogger(MessageParser.class);

    public static List<Message> parse(String msg) {
        byte[] bytes = msg.getBytes();
        return MessageParser.parse(bytes, bytes.length);
    }

    public static List<Message> parse(byte[] bytes, int length) {
        ArrayList<Message> list = new ArrayList<Message>();
        logger.debug("Parsing {} bytes", (Object)length);
        String str = new String(bytes, 0, length);
        String[] parts = str.split("[;]");
        logger.debug("Got {} parts", (Object)parts.length);
        for (String part : parts) {
            String[] keyValue = part.split("[:]");
            if (keyValue.length > 2 || !part.contains(":")) {
                logger.warn("invalid delimiters in message: '{}'", (Object)part);
                continue;
            }
            Message message = null;
            if (keyValue.length == 2) {
                message = new Message(keyValue[0], keyValue[1]);
            } else if (keyValue.length == 1) {
                message = new Message(keyValue[0], "");
            }
            logger.debug("Got message: {}", message);
            list.add(message);
        }
        return list;
    }
}

