/*
 * Decompiled with CFR 0.152.
 */
package li.rudin.arduino.api.message;

import java.util.ArrayList;
import li.rudin.arduino.api.message.Message;
import li.rudin.arduino.api.message.MessageParseResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageParser {
    private static final Logger logger = LoggerFactory.getLogger(MessageParser.class);

    public static MessageParseResult parse(String msg) {
        byte[] bytes = msg.getBytes();
        return MessageParser.parse(bytes, bytes.length);
    }

    public static MessageParseResult parse(byte[] bytes, int length) {
        ArrayList<Message> list = new ArrayList<Message>();
        int cosumedBytes = 0;
        logger.debug("Parsing {} bytes", (Object)length);
        String str = new String(bytes, 0, length);
        if (!str.contains("\n")) {
            return new MessageParseResult(list, 0);
        }
        String[] parts = str.split("[\n]");
        logger.debug("Got {} parts", (Object)parts.length);
        for (String part : parts) {
            String[] keyValue = part.split("[:]");
            if (keyValue.length > 2 || !part.contains(":")) {
                logger.debug("invalid delimiters in part: '{}' message: '{}'", (Object)part, (Object)str);
                continue;
            }
            Message message = null;
            if (keyValue.length == 2) {
                message = new Message(keyValue[0], keyValue[1]);
            } else if (keyValue.length == 1) {
                message = new Message(keyValue[0], "");
            }
            logger.debug("Got message: {}", message);
            cosumedBytes += part.length() + "\n".length();
            list.add(message);
        }
        return new MessageParseResult(list, cosumedBytes);
    }
}

