package li.rudin.arduino.api;

import li.rudin.arduino.api.cache.KeyValueCache;
import li.rudin.arduino.api.listener.ArduinoListener;
import li.rudin.arduino.api.state.ConnectionState;

public interface Arduino
{
	/**
	 * Sends a message
	 * @param key
	 * @param value
	 */
	void send(String key, String value);
	
	/**
	 * Returns a value
	 * @param key
	 * @return
	 */
	String get(String key);
	
	/**
	 * Returns the current state
	 * @return
	 */
	ConnectionState getCurrentState();
	
	/**
	 * Returns the targeted state
	 * @return
	 */
	ConnectionState getTargetState();
	
	/**
	 * Sets the target state
	 * @param state
	 */
	void setTargetState(ConnectionState state);
	
	/**
	 * Adds a listener
	 * @param listener
	 */
	void addListener(ArduinoListener listener);
	
	/**
	 * Removes a listener
	 * @param listener
	 */
	void removeListener(ArduinoListener listener);
	
	/**
	 * Sets the cache implementation
	 * @param cache
	 */
	void setCache(KeyValueCache cache);
	
	/**
	 * Returns the current cache implementation
	 * @return
	 */
	KeyValueCache getCache();

}
