package li.rudin.arduino.api.listener;

import li.rudin.arduino.api.state.ConnectionState;

public interface ArduinoListener
{
	/**
	 * Invoked on incoming message
	 * @param key
	 * @param value
	 */
	void onMessageReceived(String key, String value);
	
	/**
	 * Invoked on outgoing message
	 * @param key
	 * @param value
	 */
	void onMessageTransmitted(String key, String value);
	
	/**
	 * Invoked on state change
	 * @param currentState
	 * @param targetState
	 */
	void onStateChange(ConnectionState currentState, ConnectionState targetState);
}
