/*
 * Decompiled with CFR 0.152.
 */
package li.rudin.arduino.core.cache;

import java.util.HashMap;
import java.util.Map;
import li.rudin.arduino.api.cache.KeyValueCache;

public class TimedKeyValueCache
implements KeyValueCache {
    private final Map<String, CachedEntry> entries = new HashMap<String, CachedEntry>();
    private final long maxAge;

    public TimedKeyValueCache(long maxAge) {
        this.maxAge = maxAge;
    }

    public TimedKeyValueCache() {
        this(1000L);
    }

    public void put(String key, String value) {
        this.entries.put(key, new CachedEntry(key, value));
    }

    public boolean isCached(String key) {
        CachedEntry entry = this.entries.get(key);
        return entry != null && entry.getAge() <= this.maxAge;
    }

    public String get(String key) {
        return this.entries.get((Object)key).value;
    }

    static class CachedEntry {
        final String key;
        final String value;
        final long time;

        CachedEntry(String key, String value) {
            this.key = key;
            this.value = value;
            this.time = System.currentTimeMillis();
        }

        long getAge() {
            return System.currentTimeMillis() - this.time;
        }
    }
}

