/*
 * Decompiled with CFR 0.152.
 */
package li.rudin.arduino.core.ethernet;

import java.io.InputStream;
import li.rudin.arduino.api.message.Message;
import li.rudin.arduino.api.message.MessageParseResult;
import li.rudin.arduino.api.message.MessageParser;
import li.rudin.arduino.api.state.ConnectionState;
import li.rudin.arduino.core.ethernet.ArduinoEthernetImpl;
import li.rudin.arduino.core.ethernet.ReconnectTimer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReceiveListener
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(ReceiveListener.class);
    private final InputStream input;
    private final ArduinoEthernetImpl arduino;

    public ReceiveListener(InputStream input, ArduinoEthernetImpl arduino) {
        this.input = input;
        this.arduino = arduino;
    }

    @Override
    public void run() {
        logger.debug("Entering rx-listener thread");
        try {
            int BUFFER_SIZE = 4096;
            int bufferPos = 0;
            byte[] buffer = new byte[4096];
            while (this.arduino.getCurrentState() == ConnectionState.CONNECTED) {
                int count;
                if (bufferPos >= 4096) {
                    logger.debug("Resetting bufferPos");
                    bufferPos = 0;
                }
                if ((count = this.input.read(buffer, bufferPos, 4096 - bufferPos)) < 0) {
                    throw new IllegalArgumentException("No more data");
                }
                logger.debug("Received {} bytes of data @ bufferPos {}", (Object)count, (Object)bufferPos);
                bufferPos += count;
                try {
                    MessageParseResult result = MessageParser.parse((byte[])buffer, (int)bufferPos);
                    for (Message msg : result.getMessages()) {
                        logger.debug("Received message: {}", (Object)msg);
                        this.arduino.fireReceived(msg.key, msg.value);
                    }
                    for (int i = 0; i < bufferPos - result.getConsumedBytes(); ++i) {
                        buffer[i] = buffer[i + result.getConsumedBytes()];
                    }
                    bufferPos -= result.getConsumedBytes();
                }
                catch (Exception e) {
                    logger.debug("Parser exception", (Throwable)e);
                    bufferPos = 0;
                }
            }
        }
        catch (Exception e) {
            if (this.arduino.getTargetState() == ConnectionState.DISCONNECTED) {
                logger.debug("Exiting rx-listener thread: manual disconnect");
                return;
            }
            logger.debug("Caught exception, reconnecting", (Throwable)e);
            this.arduino.disconnect();
            new Thread(new ReconnectTimer(this.arduino, 5000L)).start();
            logger.debug("Exiting rx-listener thread: connection error");
            return;
        }
    }
}

