package li.rudin.arduino.core;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

import li.rudin.arduino.api.Arduino;
import li.rudin.arduino.api.listener.ArduinoListener;

public abstract class ObservableArduino implements Arduino
{
	
	private final List<ArduinoListener> listeners = new CopyOnWriteArrayList<>();

	@Override
	public void addListener(ArduinoListener listener)
	{
		listeners.add(listener);
	}

	@Override
	public void removeListener(ArduinoListener listener)
	{
		listeners.remove(listener);
	}
	
	/**
	 * Fires the rx event
	 * @param key
	 * @param value
	 */
	public void fireReceived(String key, String value)
	{
		for (ArduinoListener l: listeners)
			l.onMessageReceived(key, value);
	}

	/**
	 * Fires the tx event
	 * @param key
	 * @param value
	 */
	public void fireTransmitted(String key, String value)
	{
		for (ArduinoListener l: listeners)
			l.onMessageTransmitted(key, value);
	}

}
