package li.rudin.arduino.core.ethernet;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;


public class ReconnectTimer implements Runnable
{
	/**
	 * Local logger
	 */
	private static final Logger logger = LoggerFactory.getLogger(ReconnectTimer.class);
	
	
	public ReconnectTimer(ArduinoEthernetImpl dev, long delay)
	{
		this.dev = dev;
		this.delay = delay;
	}
	
	private final ArduinoEthernetImpl dev;
	private final long delay;
	
	@Override
	public void run()
	{
		try
		{
			logger.debug("Waiting {} millis for reconnect", delay);
			
			Thread.sleep(delay);
			dev.connect();
		}
		catch (Exception e) {}
	}

}
