package li.rudin.arduino.core.cache;

import li.rudin.arduino.api.Arduino;
import li.rudin.arduino.api.listener.ArduinoListener;
import li.rudin.arduino.api.state.ConnectionState;

public class CacheListener implements ArduinoListener
{
	public CacheListener(Arduino arduino)
	{
		this.arduino = arduino;
	}
	
	private final Arduino arduino;

	@Override
	public void onMessageReceived(String key, String value)
	{
		arduino.getCache().put(key, value);
	}

	@Override
	public void onMessageTransmitted(String key, String value) {}

	@Override
	public void onStateChange(ConnectionState currentState, ConnectionState targetState) {}
	
	
}
