package li.rudin.arduino.core.cache;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

import li.rudin.arduino.api.cache.KeyValueCache;

public class TimedKeyValueCache implements KeyValueCache
{
	/**
	 * Cache map
	 */
	private final Map<String, CachedEntry> entries = new ConcurrentHashMap<String, TimedKeyValueCache.CachedEntry>();

	public TimedKeyValueCache(long maxAge)
	{
		this.maxAge = maxAge;
	}
	
	private final long maxAge;
	
	public TimedKeyValueCache()
	{
		this(1000);
	}
	
	@Override
	public void put(String key, String value)
	{
		entries.put(key, new CachedEntry(key, value));
	}

	@Override
	public boolean isCached(String key)
	{
		CachedEntry entry = entries.get(key);
		
		if (entry == null || entry.getAge() > maxAge)
			return false;
		
		return true;
	}

	@Override
	public String get(String key)
	{
		return entries.get(key).value;
	}

	static class CachedEntry
	{
		CachedEntry(String key, String value)
		{
			this.key = key;
			this.value = value;
			this.time = System.currentTimeMillis();
		}
		
		final String key;
		final String value;
		final long time;
		
		long getAge()
		{
			return System.currentTimeMillis() - time;
		}
	}

	@Override
	public void invalidate()
	{
		entries.clear();
	}
	
}
