package li.rudin.arduino.core.ethernet;

import li.rudin.arduino.api.state.ConnectionState;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;


public class ReconnectTimer implements Runnable
{
	/**
	 * Local logger
	 */
	private static final Logger logger = LoggerFactory.getLogger(ReconnectTimer.class);


	public ReconnectTimer(ArduinoEthernetImpl dev)
	{
		this.dev = dev;
	}

	private final ArduinoEthernetImpl dev;

	@Override
	public void run()
	{
		logger.debug("Starting reconnect");

		try
		{
			Thread.sleep(5000);
		}
		catch (Exception e){}

		if (dev.getTargetState() == ConnectionState.CONNECTED)
			//Allow reconnect
			dev.connect();
	}

}
