package li.rudin.arduino.core.pool;

import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class ArduinoThreadPool
{

	private static ArduinoThreadPool instance = new ArduinoThreadPool();
	public static ArduinoThreadPool getInstance() { return instance; }
	
	private ArduinoThreadPool()
	{
		pool = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 5, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new ArduinoThreadFactory());
	}

	/**
	 * On demand thread pool
	 */
	private ThreadPoolExecutor pool;

	@Override
	protected void finalize() throws Throwable
	{
		pool.shutdown();
		pool = null;
	}

	/**
	 * Submits a runnable
	 * @param r
	 */
	public void submit(Runnable r)
	{
		pool.submit(r);
	}
	
	
}
