/*
 * Decompiled with CFR 0.152.
 */
package li.rudin.arduino.core;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import li.rudin.arduino.api.Arduino;
import li.rudin.arduino.api.listener.ArduinoListener;

public abstract class ObservableArduino
implements Arduino {
    private final List<ArduinoListener> listeners = new CopyOnWriteArrayList<ArduinoListener>();

    public void addListener(ArduinoListener listener) {
        this.listeners.add(listener);
        listener.onStateChange(this.getCurrentState(), this.getTargetState());
    }

    public void removeListener(ArduinoListener listener) {
        this.listeners.remove(listener);
    }

    public void fireReceived(String key, String value) {
        for (ArduinoListener l : this.listeners) {
            l.onMessageReceived(key, value);
        }
    }

    public void fireTransmitted(String key, String value) {
        for (ArduinoListener l : this.listeners) {
            l.onMessageTransmitted(key, value);
        }
    }

    public void fireStateChange() {
        for (ArduinoListener l : this.listeners) {
            l.onStateChange(this.getCurrentState(), this.getTargetState());
        }
    }
}

