/*
 * Decompiled with CFR 0.152.
 */
package li.rudin.arduino.core.ethernet;

import java.io.IOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import li.rudin.arduino.api.cache.KeyValueCache;
import li.rudin.arduino.api.ethernet.ArduinoEthernet;
import li.rudin.arduino.api.message.Message;
import li.rudin.arduino.api.state.ConnectionState;
import li.rudin.arduino.core.ObservableArduino;
import li.rudin.arduino.core.cache.CacheListener;
import li.rudin.arduino.core.cache.NoOpKeyValueCache;
import li.rudin.arduino.core.ethernet.ReceiveListener;
import li.rudin.arduino.core.ethernet.ReconnectTimer;
import li.rudin.arduino.core.pool.ArduinoThreadPool;
import li.rudin.arduino.core.queue.MessageQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArduinoEthernetImpl
extends ObservableArduino
implements ArduinoEthernet {
    private static final Logger logger = LoggerFactory.getLogger(ArduinoEthernetImpl.class);
    private final String host;
    private final int port;
    private Socket socket;
    private OutputStream output;
    private final MessageQueue queue = new MessageQueue(this);
    private ConnectionState current = ConnectionState.DISCONNECTED;
    private ConnectionState target = ConnectionState.DISCONNECTED;
    private final Object sendLock = new Object();
    private KeyValueCache cache = new NoOpKeyValueCache();

    public ArduinoEthernetImpl(String host, int port) {
        this.host = host;
        this.port = port;
        this.addListener(this.queue);
        this.addListener(new CacheListener(this));
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public ConnectionState getCurrentState() {
        return this.current;
    }

    public ConnectionState getTargetState() {
        return this.target;
    }

    public void setTargetState(ConnectionState state) {
        ConnectionState lastState = this.target;
        this.target = state;
        if (lastState == ConnectionState.DISCONNECTED && state == ConnectionState.CONNECTED) {
            this.connect();
        } else if (lastState == ConnectionState.CONNECTED && state == ConnectionState.DISCONNECTED) {
            this.disconnect();
        }
    }

    public void connect() {
        ArduinoThreadPool pool = ArduinoThreadPool.getInstance();
        logger.debug("Connecting to {}:{}", (Object)this.host, (Object)this.port);
        try {
            this.socket = new Socket();
            this.socket.setTcpNoDelay(true);
            this.socket.connect(new InetSocketAddress(this.host, this.port), 1000);
            this.current = ConnectionState.CONNECTED;
            this.output = this.socket.getOutputStream();
            pool.submit(new ReceiveListener(this.socket.getInputStream(), this));
        }
        catch (Exception e) {
            logger.debug("Connect error", (Throwable)e);
            this.disconnect();
            pool.submit(new ReconnectTimer(this));
        }
        this.fireStateChange();
    }

    public void disconnect() {
        logger.debug("Disconnecting from {}:{}", (Object)this.host, (Object)this.port);
        this.current = ConnectionState.DISCONNECTED;
        try {
            this.output = null;
            this.socket.close();
        }
        catch (Exception e) {
            logger.debug("disconnect", (Throwable)e);
        }
        this.fireStateChange();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(String key, String value) {
        Message msg = new Message(key, value);
        logger.debug("Sending message: '{}'", (Object)msg);
        if (this.current == ConnectionState.CONNECTED && this.output != null) {
            try {
                Object object = this.sendLock;
                synchronized (object) {
                    this.output.write(msg.getBytes());
                    this.output.flush();
                }
                this.fireTransmitted(key, value);
                logger.debug("Sent message: '{}'", (Object)msg);
            }
            catch (IOException e) {
                logger.debug("send failed", (Throwable)e);
            }
        } else {
            logger.debug("Not Sending message (not connected): '{}'", (Object)msg);
        }
    }

    public Socket getSocket() {
        return this.socket;
    }

    public String get(String key) {
        if (this.cache.isCached(key)) {
            return this.cache.get(key);
        }
        return this.queue.get(key, "", 5000);
    }

    public void setCache(KeyValueCache cache) {
        this.cache = cache;
    }

    public KeyValueCache getCache() {
        return this.cache;
    }
}

