/*
 * Decompiled with CFR 0.152.
 */
package li.rudin.arduino.core.queue;

import java.util.HashMap;
import java.util.Map;
import li.rudin.arduino.api.Arduino;
import li.rudin.arduino.api.listener.ArduinoListener;
import li.rudin.arduino.api.state.ConnectionState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageQueue
implements ArduinoListener {
    private static final Logger logger = LoggerFactory.getLogger(MessageQueue.class);
    private final Arduino device;
    private final Map<String, ResultHolder> locks = new HashMap<String, ResultHolder>();

    public MessageQueue(Arduino device) {
        logger.trace("Created new queue: {}", (Object)this);
        this.device = device;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessageReceived(String key, String value) {
        ResultHolder result;
        Object object = this.locks;
        synchronized (object) {
            if (!this.locks.containsKey(key)) {
                return;
            }
            result = this.locks.get(key);
        }
        object = result;
        synchronized (object) {
            logger.trace("Notifying: {}", (Object)result);
            result.setResult(value);
            result.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String get(String key, String value, int timeout) {
        ResultHolder result;
        Map<String, ResultHolder> map = this.locks;
        synchronized (map) {
            result = this.locks.get(key);
            if (result == null) {
                result = new ResultHolder();
                this.locks.put(key, result);
            }
        }
        this.device.send(key, value);
        long timeoutExpires = System.currentTimeMillis() + (long)timeout;
        ResultHolder resultHolder = result;
        synchronized (resultHolder) {
            try {
                do {
                    logger.trace("Waiting {} s for Result: {}", (Object)timeout, (Object)result);
                    result.wait(timeout);
                } while (System.currentTimeMillis() < timeoutExpires && result.getResult() == null);
            }
            catch (InterruptedException e) {
                return null;
            }
            String ret = result.getResult();
            logger.trace("Got Result: {}", (Object)ret);
            return ret;
        }
    }

    public void onMessageTransmitted(String key, String value) {
    }

    public void onStateChange(ConnectionState currentState, ConnectionState targetState) {
    }

    private class ResultHolder {
        private String result;

        private ResultHolder() {
        }

        public String getResult() {
            return this.result;
        }

        public void setResult(String result) {
            this.result = result;
        }
    }
}

