/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.docs.commons;

import java.util.Objects;

public class KeyValueEntry
implements Comparable<KeyValueEntry> {
    private final String name;
    private final String description;

    public KeyValueEntry(String name, String description) {
        this.name = name;
        this.description = description;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KeyValueEntry tag = (KeyValueEntry)o;
        return Objects.equals(this.name, tag.name) && Objects.equals(this.description, tag.description);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.description);
    }

    @Override
    public int compareTo(KeyValueEntry o) {
        return this.name.compareTo(o.name);
    }

    public String toString() {
        return "|`" + this.name + "`|" + this.description();
    }

    private String description() {
        String suffix = "";
        if (this.name.contains("%s")) {
            suffix = " (since the name contains `%s` the final value will be resolved at runtime)";
        }
        return this.description + suffix;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }
}

