/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.docs.commons;

import io.micrometer.common.docs.KeyName;
import io.micrometer.common.lang.Nullable;
import io.micrometer.common.util.internal.logging.InternalLogger;
import io.micrometer.common.util.internal.logging.InternalLoggerFactory;
import io.micrometer.docs.commons.KeyValueEntry;
import io.micrometer.observation.Observation;
import java.io.File;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jboss.forge.roaster.Roaster;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.CompilationUnit;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.Expression;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.ImportDeclaration;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.MethodDeclaration;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.MethodInvocation;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.QualifiedName;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.ReturnStatement;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.StringLiteral;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.Type;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.TypeLiteral;
import org.jboss.forge.roaster.model.JavaType;
import org.jboss.forge.roaster.model.JavaUnit;
import org.jboss.forge.roaster.model.impl.AbstractJavaSource;
import org.jboss.forge.roaster.model.impl.JavaClassImpl;
import org.jboss.forge.roaster.model.impl.JavaEnumImpl;
import org.jboss.forge.roaster.model.impl.JavaUnitImpl;
import org.jboss.forge.roaster.model.impl.MethodImpl;
import org.jboss.forge.roaster.model.source.EnumConstantSource;
import org.jboss.forge.roaster.model.source.JavaSource;
import org.jboss.forge.roaster.model.source.MemberSource;
import org.jboss.forge.roaster.model.source.MethodSource;

public class ParsingUtils {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(ParsingUtils.class);

    public static void updateKeyValuesFromEnum(JavaEnumImpl parentEnum, JavaSource<?> source, Class requiredClass, Collection<KeyValueEntry> keyValues) {
        if (!(source instanceof JavaEnumImpl)) {
            return;
        }
        JavaEnumImpl myEnum = (JavaEnumImpl)source;
        if (!myEnum.getInterfaces().contains(requiredClass.getCanonicalName())) {
            return;
        }
        logger.debug("Checking [" + parentEnum.getName() + "." + myEnum.getName() + "]");
        if (myEnum.getEnumConstants().size() == 0) {
            return;
        }
        for (EnumConstantSource enumConstant : myEnum.getEnumConstants()) {
            String keyValue = ParsingUtils.enumKeyValue(enumConstant);
            keyValues.add(new KeyValueEntry(keyValue, enumConstant.getJavaDoc().getText()));
        }
    }

    public static String readStringReturnValue(MethodDeclaration methodDeclaration) {
        return ParsingUtils.stringFromReturnMethodDeclaration(methodDeclaration);
    }

    @Nullable
    public static String tryToReadStringReturnValue(Path file, String clazz) {
        try {
            return ParsingUtils.tryToReadNameFromConventionClass(file, clazz);
        }
        catch (Exception ex) {
            return null;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static String tryToReadNameFromConventionClass(Path file, String className) {
        block19: {
            File parent = file.getParent().toFile();
            while (!parent.getAbsolutePath().endsWith(File.separator + "java")) {
                parent = parent.getParentFile();
            }
            String filePath = ParsingUtils.filePath(className, parent);
            try (InputStream streamForOverride = Files.newInputStream(new File(filePath).toPath(), new OpenOption[0]);){
                JavaType actualConventionImplementation;
                List nestedTypes;
                JavaUnit parsedClass = Roaster.parseUnit((InputStream)streamForOverride);
                if (className.contains("$")) {
                    String actualName = className.substring(className.indexOf("$") + 1);
                    nestedTypes = ((AbstractJavaSource)parsedClass.getGoverningType()).getNestedTypes();
                    AbstractJavaSource foundType = nestedTypes.stream().filter(o -> o.getName().equals(actualName)).findFirst().orElseThrow(() -> new IllegalStateException("Can't find a class with fqb [" + className + "]"));
                    actualConventionImplementation = (JavaType)foundType;
                } else if (parsedClass instanceof JavaUnitImpl) {
                    actualConventionImplementation = parsedClass.getGoverningType();
                } else {
                    String actualName = null;
                    return actualName;
                }
                if (!(actualConventionImplementation instanceof JavaClassImpl)) break block19;
                List interfaces = ((JavaClassImpl)actualConventionImplementation).getInterfaces();
                if (interfaces.stream().noneMatch(s -> s.contains(Observation.ObservationConvention.class.getSimpleName()))) {
                    nestedTypes = null;
                    return nestedTypes;
                }
                MethodSource name = ((JavaClassImpl)actualConventionImplementation).getMethod("getName");
                try {
                    MethodDeclaration methodDeclaration = (MethodDeclaration)Arrays.stream(MethodImpl.class.getDeclaredFields()).filter(f -> f.getName().equals("method")).findFirst().map(f -> {
                        try {
                            f.setAccessible(true);
                            return f.get(name);
                        }
                        catch (IllegalAccessException e) {
                            throw new RuntimeException(e);
                        }
                    }).get();
                    String string = ParsingUtils.readStringReturnValue(methodDeclaration);
                    return string;
                }
                catch (Exception ex) {
                    String string;
                    block20: {
                        string = name.toString().replace("return ", "").replace("\"", "");
                        if (streamForOverride == null) break block20;
                        streamForOverride.close();
                    }
                    return string;
                }
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }
        return "";
    }

    private static String filePath(String className, File parent) {
        if (className.contains("$")) {
            return new File(parent, className.replace(".", File.separator).substring(0, className.indexOf("$")) + ".java").getAbsolutePath();
        }
        return new File(parent, className.replace(".", File.separator) + ".java").getAbsolutePath();
    }

    public static Collection<KeyValueEntry> keyValueEntries(JavaEnumImpl myEnum, MethodDeclaration methodDeclaration, Class requiredClass) {
        Collection<String> enumNames = ParsingUtils.readClassValue(methodDeclaration);
        TreeSet<KeyValueEntry> keyValues = new TreeSet<KeyValueEntry>();
        enumNames.forEach(enumName -> {
            List nestedTypes = myEnum.getNestedTypes();
            JavaSource nestedSource = nestedTypes.stream().filter(javaSource -> javaSource.getName().equals(enumName)).findFirst().orElseThrow(() -> new IllegalStateException("There's no nested type with name [" + enumName + "]"));
            ParsingUtils.updateKeyValuesFromEnum(myEnum, nestedSource, requiredClass, keyValues);
        });
        return keyValues;
    }

    public static Collection<String> readClassValue(MethodDeclaration methodDeclaration) {
        Object statement = methodDeclaration.getBody().statements().get(0);
        if (!(statement instanceof ReturnStatement)) {
            logger.warn("Statement [" + statement.getClass() + "] is not a return statement.");
            return Collections.emptyList();
        }
        ReturnStatement returnStatement = (ReturnStatement)statement;
        Expression expression = returnStatement.getExpression();
        if (!(expression instanceof MethodInvocation)) {
            logger.warn("Statement [" + statement.getClass() + "] is not a method invocation.");
            return Collections.emptyList();
        }
        MethodInvocation methodInvocation = (MethodInvocation)expression;
        if ("merge".equals(methodInvocation.getName().getIdentifier())) {
            String invocationString = methodInvocation.toString();
            Matcher matcher = Pattern.compile("([a-zA-Z]+.values)").matcher(invocationString);
            TreeSet<String> classNames = new TreeSet<String>();
            while (matcher.find()) {
                String className = matcher.group(1).split("\\.")[0];
                classNames.add(className);
            }
            return classNames;
        }
        if (!methodInvocation.toString().endsWith(".values()")) {
            throw new IllegalStateException("You have to use the static .values() method on the enum that implements " + KeyName.class + " interface or use [KeyName.merge(...)] method to merge multiple values from tags");
        }
        return Collections.singletonList(methodInvocation.getExpression().toString());
    }

    private static String enumKeyValue(EnumConstantSource enumConstant) {
        List members = enumConstant.getBody().getMembers();
        if (members.isEmpty()) {
            logger.warn("No method declarations in the enum.");
            return "";
        }
        Object internal = ((MemberSource)members.get(0)).getInternal();
        if (!(internal instanceof MethodDeclaration)) {
            logger.warn("Can't read the member [" + internal.getClass() + "] as a method declaration.");
            return "";
        }
        MethodDeclaration methodDeclaration = (MethodDeclaration)internal;
        if (methodDeclaration.getBody().statements().isEmpty()) {
            logger.warn("Body was empty. Continuing...");
            return "";
        }
        return ParsingUtils.stringFromReturnMethodDeclaration(methodDeclaration);
    }

    private static String stringFromReturnMethodDeclaration(MethodDeclaration methodDeclaration) {
        Object statement = methodDeclaration.getBody().statements().get(0);
        if (!(statement instanceof ReturnStatement)) {
            logger.warn("Statement [" + statement.getClass() + "] is not a return statement.");
            return "";
        }
        ReturnStatement returnStatement = (ReturnStatement)statement;
        Expression expression = returnStatement.getExpression();
        if (!(expression instanceof StringLiteral)) {
            logger.warn("Statement [" + statement.getClass() + "] is not a string literal statement.");
            return "";
        }
        return ((StringLiteral)expression).getLiteralValue();
    }

    public static <T extends Enum> T enumFromReturnMethodDeclaration(MethodDeclaration methodDeclaration, Class<T> enumClass) {
        Object statement = methodDeclaration.getBody().statements().get(0);
        if (!(statement instanceof ReturnStatement)) {
            logger.warn("Statement [" + statement.getClass() + "] is not a return statement.");
            return null;
        }
        ReturnStatement returnStatement = (ReturnStatement)statement;
        Expression expression = returnStatement.getExpression();
        if (!(expression instanceof QualifiedName)) {
            logger.warn("Statement [" + statement.getClass() + "] is not a qualified statement.");
            return null;
        }
        QualifiedName qualifiedName = (QualifiedName)expression;
        String enumName = qualifiedName.getName().toString();
        return Enum.valueOf(enumClass, enumName);
    }

    public static String readClass(MethodDeclaration methodDeclaration) {
        Object statement = methodDeclaration.getBody().statements().get(0);
        if (!(statement instanceof ReturnStatement)) {
            logger.warn("Statement [" + statement.getClass() + "] is not a return statement.");
            return null;
        }
        ReturnStatement returnStatement = (ReturnStatement)statement;
        Expression expression = returnStatement.getExpression();
        if (!(expression instanceof TypeLiteral)) {
            logger.warn("Statement [" + statement.getClass() + "] is not a qualified name.");
            return null;
        }
        TypeLiteral typeLiteral = (TypeLiteral)expression;
        Type type = typeLiteral.getType();
        String className = type.toString();
        return ParsingUtils.matchingImportStatement(expression, className);
    }

    public static Map.Entry<String, String> readClassToEnum(MethodDeclaration methodDeclaration) {
        Object statement = methodDeclaration.getBody().statements().get(0);
        if (!(statement instanceof ReturnStatement)) {
            logger.warn("Statement [" + statement.getClass() + "] is not a return statement.");
            return null;
        }
        ReturnStatement returnStatement = (ReturnStatement)statement;
        Expression expression = returnStatement.getExpression();
        if (!(expression instanceof QualifiedName)) {
            logger.warn("Statement [" + statement.getClass() + "] is not a qualified name.");
            return null;
        }
        QualifiedName qualifiedName = (QualifiedName)expression;
        String className = qualifiedName.getQualifier().toString();
        String enumName = qualifiedName.getName().toString();
        String matchingImportStatement = ParsingUtils.matchingImportStatement(expression, className);
        return new AbstractMap.SimpleEntry<String, String>(matchingImportStatement, enumName);
    }

    private static String matchingImportStatement(Expression expression, String className) {
        CompilationUnit compilationUnit = (CompilationUnit)expression.getRoot();
        List imports = compilationUnit.imports();
        String matchingImportStatement = compilationUnit.getPackage().getName().toString() + "." + className;
        for (Object anImport : imports) {
            ImportDeclaration importDeclaration = (ImportDeclaration)anImport;
            String importStatement = importDeclaration.getName().toString();
            if (!importStatement.endsWith(className)) continue;
            matchingImportStatement = importStatement;
        }
        return ParsingUtils.matchingStatementFromInnerClasses(className, compilationUnit, matchingImportStatement);
    }

    private static String matchingStatementFromInnerClasses(String className, CompilationUnit compilationUnit, String matchingImportStatement) {
        for (Object type : compilationUnit.types()) {
            if (!(type instanceof AbstractTypeDeclaration)) continue;
            AbstractTypeDeclaration typeDeclaration = (AbstractTypeDeclaration)type;
            List declarations = typeDeclaration.bodyDeclarations();
            for (Object declaration : declarations) {
                AbstractTypeDeclaration childDeclaration = (AbstractTypeDeclaration)declaration;
                if (!className.equals(childDeclaration.getName().toString())) continue;
                return compilationUnit.getPackage().getName().toString() + "." + typeDeclaration.getName() + "$" + childDeclaration.getName();
            }
        }
        return matchingImportStatement;
    }

    public static Collection<KeyValueEntry> getTags(EnumConstantSource enumConstant, JavaEnumImpl myEnum, String getterName) {
        List members = enumConstant.getBody().getMembers();
        if (members.isEmpty()) {
            return Collections.emptyList();
        }
        TreeSet<KeyValueEntry> tags = new TreeSet<KeyValueEntry>();
        for (MemberSource member : members) {
            Object internal = member.getInternal();
            if (!(internal instanceof MethodDeclaration)) {
                return null;
            }
            MethodDeclaration methodDeclaration = (MethodDeclaration)internal;
            String methodName = methodDeclaration.getName().getIdentifier();
            if (!getterName.equals(methodName)) continue;
            tags.addAll(ParsingUtils.keyValueEntries(myEnum, methodDeclaration, KeyName.class));
        }
        return tags;
    }
}

