/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.docs.metrics;

import io.micrometer.api.internal.logging.InternalLogger;
import io.micrometer.api.internal.logging.InternalLoggerFactory;
import io.micrometer.docs.metrics.MetricEntry;
import io.micrometer.docs.metrics.MetricSearchingFileVisitor;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.TreeSet;
import java.util.regex.Pattern;

public class DocsFromSources {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(DocsFromSources.class);
    private final File projectRoot;
    private final Pattern inclusionPattern;
    private final File outputDir;

    public DocsFromSources(File projectRoot, Pattern inclusionPattern, File outputDir) {
        this.projectRoot = projectRoot;
        this.inclusionPattern = inclusionPattern;
        this.outputDir = outputDir;
    }

    public static void main(String ... args) {
        String projectRoot = args[0];
        String inclusionPattern = args[1];
        inclusionPattern = inclusionPattern.replace("/", File.separator);
        String output = args[2];
        new DocsFromSources(new File(projectRoot), Pattern.compile(inclusionPattern), new File(output)).generate();
    }

    public void generate() {
        Path path = this.projectRoot.toPath();
        logger.info("Path is [" + this.projectRoot.getAbsolutePath() + "]. Inclusion pattern is [" + this.inclusionPattern + "]");
        TreeSet<MetricEntry> entries = new TreeSet<MetricEntry>();
        MetricSearchingFileVisitor fv = new MetricSearchingFileVisitor(this.inclusionPattern, entries);
        try {
            Files.walkFileTree(path, fv);
            MetricEntry.assertThatProperlyPrefixed(entries);
            File file = new File(this.outputDir, "_metrics.adoc");
            if (!file.exists()) {
                file.getParentFile().mkdirs();
                file.createNewFile();
            }
            logger.info("Will create files under [" + file + "]");
            StringBuilder stringBuilder = new StringBuilder();
            Path output = file.toPath();
            logger.info("======================================");
            logger.info("Summary of sources analysis");
            logger.info("Found [" + entries.size() + "] samples");
            logger.info("Found [" + entries.stream().flatMap(e -> e.lowCardinalityTagKeys.stream()).distinct().count() + "] low cardinality tags");
            logger.info("Found [" + entries.stream().flatMap(e -> e.highCardinalityTagKeys.stream()).distinct().count() + "] high cardinality tags");
            stringBuilder.append("[[observability-metrics]]\n=== Observability - Metrics\n\nBelow you can find a list of all samples declared by this project.\n\n");
            entries.forEach(metricEntry -> stringBuilder.append(metricEntry.toString()).append("\n\n"));
            Files.write(output, stringBuilder.toString().getBytes(), new OpenOption[0]);
        }
        catch (IOException e2) {
            throw new IllegalArgumentException(e2);
        }
    }
}

