/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.docs.metrics;

import io.micrometer.api.instrument.Meter;
import io.micrometer.docs.commons.KeyValueEntry;
import io.micrometer.docs.commons.utils.Assert;
import io.micrometer.docs.commons.utils.StringUtils;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

class MetricEntry
implements Comparable<MetricEntry> {
    final String name;
    final String enclosingClass;
    final String enumName;
    final String description;
    final String prefix;
    final String baseUnit;
    final Meter.Type type;
    final Collection<KeyValueEntry> lowCardinalityTagKeys;
    final Collection<KeyValueEntry> highCardinalityTagKeys;
    final Map.Entry<String, String> overridesDefaultMetricFrom;

    MetricEntry(String name, String enclosingClass, String enumName, String description, String prefix, String baseUnit, Meter.Type meterType, Collection<KeyValueEntry> lowCardinalityTagKeys, Collection<KeyValueEntry> highCardinalityTagKeys, Map.Entry<String, String> overridesDefaultMetricFrom) {
        Assert.hasText((String)name, (String)("Observation / Meter name must not be empty. Check <" + enclosingClass + "#" + enumName + ">"));
        Assert.hasText((String)description, (String)("Observation / Meter description must not be empty. Check <" + enclosingClass + "#" + enumName + ">"));
        this.name = name;
        this.enclosingClass = enclosingClass;
        this.enumName = enumName;
        this.description = description;
        this.prefix = prefix;
        this.baseUnit = StringUtils.hasText((String)baseUnit) ? baseUnit : (meterType == Meter.Type.TIMER ? "seconds" : "");
        this.type = meterType;
        this.lowCardinalityTagKeys = lowCardinalityTagKeys;
        this.highCardinalityTagKeys = highCardinalityTagKeys;
        this.overridesDefaultMetricFrom = overridesDefaultMetricFrom;
    }

    static void assertThatProperlyPrefixed(Collection<MetricEntry> entries) {
        List collect = entries.stream().map(MetricEntry::notProperlyPrefixedTags).filter(Objects::nonNull).collect(Collectors.toList());
        if (collect.isEmpty()) {
            return;
        }
        throw new IllegalStateException("The following documented objects do not have properly prefixed tag keys according to their prefix() method. Please align the tag keys.\n\n" + collect.stream().map(e -> "\tName <" + ((MetricEntry)e.getKey()).enumName + "> in class <" + ((MetricEntry)e.getKey()).enclosingClass + "> has the following prefix <" + ((MetricEntry)e.getKey()).prefix + "> and following invalid tag keys " + e.getValue()).collect(Collectors.joining("\n")) + "\n\n");
    }

    Map.Entry<MetricEntry, List<String>> notProperlyPrefixedTags() {
        if (!StringUtils.hasText((String)this.prefix)) {
            return null;
        }
        ArrayList<KeyValueEntry> allTags = new ArrayList<KeyValueEntry>(this.lowCardinalityTagKeys);
        allTags.addAll(this.highCardinalityTagKeys);
        List collect = allTags.stream().map(KeyValueEntry::getName).filter(eName -> !eName.startsWith(this.prefix)).collect(Collectors.toList());
        if (collect.isEmpty()) {
            return null;
        }
        return new AbstractMap.SimpleEntry<MetricEntry, List<String>>(this, collect);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MetricEntry that = (MetricEntry)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.enclosingClass, that.enclosingClass) && Objects.equals(this.enumName, that.enumName) && Objects.equals(this.description, that.description) && Objects.equals(this.prefix, that.prefix) && Objects.equals(this.baseUnit, that.baseUnit) && this.type == that.type && Objects.equals(this.lowCardinalityTagKeys, that.lowCardinalityTagKeys) && Objects.equals(this.highCardinalityTagKeys, that.highCardinalityTagKeys) && Objects.equals(this.overridesDefaultMetricFrom, that.overridesDefaultMetricFrom);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.enclosingClass, this.enumName, this.description, this.prefix, this.baseUnit, this.type, this.lowCardinalityTagKeys, this.highCardinalityTagKeys, this.overridesDefaultMetricFrom);
    }

    @Override
    public int compareTo(MetricEntry o) {
        return this.enumName.compareTo(o.enumName);
    }

    public String toString() {
        String displayName = Arrays.stream(this.enumName.replace("_", " ").split(" ")).map(s -> StringUtils.capitalize((String)s.toLowerCase(Locale.ROOT))).collect(Collectors.joining(" "));
        StringBuilder text = new StringBuilder().append("[[observability-metrics-").append(displayName.toLowerCase(Locale.ROOT).replace(" ", "-")).append("]]\n").append("==== ").append(displayName).append("\n\n> ").append(this.description).append("\n\n").append("**Metric name** `").append(this.name).append("`");
        if (this.name.contains("%s")) {
            text.append(" - since it contains `%s`, the name is dynamic and will be resolved at runtime.");
        } else {
            text.append(".");
        }
        text.append(" **Type** `").append(this.type.toString().toLowerCase(Locale.ROOT).replace("_", " "));
        if (StringUtils.hasText((String)this.baseUnit)) {
            text.append("` and **base unit** `").append(this.baseUnit.toLowerCase(Locale.ROOT));
        }
        text.append("`.").append("\n\n").append("Fully qualified name of the enclosing class `").append(this.enclosingClass).append("`.");
        if (StringUtils.hasText((String)this.prefix)) {
            text.append("\n\nIMPORTANT: All tags must be prefixed with `").append(this.prefix).append("` prefix!");
        }
        if (!this.lowCardinalityTagKeys.isEmpty()) {
            text.append("\n\n.Low cardinality Keys\n|===\n|Name | Description\n").append(this.lowCardinalityTagKeys.stream().map(KeyValueEntry::toString).collect(Collectors.joining("\n"))).append("\n|===");
        }
        if (!this.highCardinalityTagKeys.isEmpty()) {
            text.append("\n\n.High cardinality Keys\n|===\n|Name | Description\n").append(this.highCardinalityTagKeys.stream().map(KeyValueEntry::toString).collect(Collectors.joining("\n"))).append("\n|===");
        }
        return text.toString();
    }
}

