/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.docs.metrics;

import io.micrometer.api.instrument.Meter;
import io.micrometer.api.instrument.docs.DocumentedMeter;
import io.micrometer.api.instrument.docs.DocumentedObservation;
import io.micrometer.api.instrument.docs.TagKey;
import io.micrometer.api.internal.logging.InternalLogger;
import io.micrometer.api.internal.logging.InternalLoggerFactory;
import io.micrometer.docs.commons.KeyValueEntry;
import io.micrometer.docs.commons.ParsingUtils;
import io.micrometer.docs.metrics.MetricEntry;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.jboss.forge.roaster.Roaster;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.MethodDeclaration;
import org.jboss.forge.roaster.model.JavaType;
import org.jboss.forge.roaster.model.JavaUnit;
import org.jboss.forge.roaster.model.impl.JavaEnumImpl;
import org.jboss.forge.roaster.model.source.EnumConstantSource;
import org.jboss.forge.roaster.model.source.MemberSource;

class MetricSearchingFileVisitor
extends SimpleFileVisitor<Path> {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(MetricSearchingFileVisitor.class);
    private final Pattern pattern;
    private final Collection<MetricEntry> sampleEntries;

    MetricSearchingFileVisitor(Pattern pattern, Collection<MetricEntry> sampleEntries) {
        this.pattern = pattern;
        this.sampleEntries = sampleEntries;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
        if (!this.pattern.matcher(file.toString()).matches()) {
            return FileVisitResult.CONTINUE;
        }
        if (!file.toString().endsWith(".java")) {
            return FileVisitResult.CONTINUE;
        }
        try (InputStream stream = Files.newInputStream(file, new OpenOption[0]);){
            JavaUnit unit = Roaster.parseUnit((InputStream)stream);
            JavaType myClass = unit.getGoverningType();
            if (!(myClass instanceof JavaEnumImpl)) {
                FileVisitResult fileVisitResult = FileVisitResult.CONTINUE;
                return fileVisitResult;
            }
            JavaEnumImpl myEnum = (JavaEnumImpl)myClass;
            if (Stream.of(DocumentedMeter.class.getCanonicalName(), DocumentedObservation.class.getCanonicalName()).noneMatch(ds -> myEnum.getInterfaces().contains(ds))) {
                FileVisitResult fileVisitResult = FileVisitResult.CONTINUE;
                return fileVisitResult;
            }
            logger.info("Checking [" + myEnum.getName() + "]");
            if (myEnum.getEnumConstants().size() == 0) {
                FileVisitResult fileVisitResult = FileVisitResult.CONTINUE;
                return fileVisitResult;
            }
            for (EnumConstantSource enumConstant : myEnum.getEnumConstants()) {
                MetricEntry entry = this.parseMetric(enumConstant, myEnum);
                if (entry != null) {
                    this.sampleEntries.add(entry);
                    logger.info("Found [" + entry.lowCardinalityTagKeys.size() + "] low cardinality tags and [" + entry.highCardinalityTagKeys.size() + "] high cardinality tags");
                }
                if (entry == null) continue;
                if (entry.overridesDefaultMetricFrom != null && entry.lowCardinalityTagKeys.isEmpty()) {
                    this.addTagsFromOverride(file, entry);
                }
                this.sampleEntries.add(entry);
                logger.info("Found [" + entry.lowCardinalityTagKeys.size() + "]");
            }
            Object object = FileVisitResult.CONTINUE;
            return object;
        }
        catch (Exception e) {
            logger.error("Failed to parse file [" + file + "] due to an error", (Throwable)e);
            return FileVisitResult.CONTINUE;
        }
    }

    private void addTagsFromOverride(Path file, MetricEntry entry) throws IOException {
        Map.Entry<String, String> overrideDefaults = entry.overridesDefaultMetricFrom;
        logger.info("Reading additional meta data from [" + overrideDefaults + "]");
        String className = overrideDefaults.getKey();
        File parent = file.getParent().toFile();
        while (!parent.getAbsolutePath().endsWith(File.separator + "java")) {
            parent = parent.getParentFile();
        }
        String filePath = new File(parent, className.replace(".", File.separator) + ".java").getAbsolutePath();
        try (InputStream streamForOverride = Files.newInputStream(new File(filePath).toPath(), new OpenOption[0]);){
            JavaUnit parsedForOverride = Roaster.parseUnit((InputStream)streamForOverride);
            JavaType overrideClass = parsedForOverride.getGoverningType();
            if (!(overrideClass instanceof JavaEnumImpl)) {
                return;
            }
            JavaEnumImpl myEnum = (JavaEnumImpl)overrideClass;
            if (!myEnum.getInterfaces().contains(DocumentedObservation.class.getCanonicalName())) {
                return;
            }
            logger.info("Checking [" + myEnum.getName() + "]");
            if (myEnum.getEnumConstants().size() == 0) {
                return;
            }
            for (EnumConstantSource enumConstant : myEnum.getEnumConstants()) {
                Collection low;
                if (!enumConstant.getName().equals(overrideDefaults.getValue()) || (low = ParsingUtils.getTags((EnumConstantSource)enumConstant, (JavaEnumImpl)myEnum, (String)"getLowCardinalityTagKeys")) == null) continue;
                entry.lowCardinalityTagKeys.addAll(low);
            }
        }
    }

    private MetricEntry parseMetric(EnumConstantSource enumConstant, JavaEnumImpl myEnum) {
        List members = enumConstant.getBody().getMembers();
        if (members.isEmpty()) {
            return null;
        }
        String name = "";
        String description = enumConstant.getJavaDoc().getText();
        String prefix = "";
        String baseUnit = "";
        Meter.Type type = Meter.Type.TIMER;
        TreeSet<KeyValueEntry> lowCardinalityTags = new TreeSet<KeyValueEntry>();
        TreeSet<KeyValueEntry> highCardinalityTags = new TreeSet<KeyValueEntry>();
        Map.Entry overridesDefaultMetricFrom = null;
        for (MemberSource member : members) {
            Object internal = member.getInternal();
            if (!(internal instanceof MethodDeclaration)) {
                return null;
            }
            MethodDeclaration methodDeclaration = (MethodDeclaration)internal;
            String methodName = methodDeclaration.getName().getIdentifier();
            if ("getName".equals(methodName)) {
                name = ParsingUtils.readStringReturnValue((MethodDeclaration)methodDeclaration);
                continue;
            }
            if ("getLowCardinalityTagKeys".equals(methodName) || "getTagKeys".equals(methodName)) {
                lowCardinalityTags.addAll(ParsingUtils.keyValueEntries((JavaEnumImpl)myEnum, (MethodDeclaration)methodDeclaration, TagKey.class));
                continue;
            }
            if ("getHighCardinalityTagKeys".equals(methodName)) {
                highCardinalityTags.addAll(ParsingUtils.keyValueEntries((JavaEnumImpl)myEnum, (MethodDeclaration)methodDeclaration, TagKey.class));
                continue;
            }
            if ("getPrefix".equals(methodName)) {
                prefix = ParsingUtils.readStringReturnValue((MethodDeclaration)methodDeclaration);
                continue;
            }
            if ("getBaseUnit".equals(methodName)) {
                baseUnit = ParsingUtils.readStringReturnValue((MethodDeclaration)methodDeclaration);
                continue;
            }
            if ("getType".equals(methodName)) {
                type = (Meter.Type)ParsingUtils.enumFromReturnMethodDeclaration((MethodDeclaration)methodDeclaration, Meter.Type.class);
                continue;
            }
            if ("getDescription".equals(methodName)) {
                description = ParsingUtils.readStringReturnValue((MethodDeclaration)methodDeclaration);
                continue;
            }
            if (!"overridesDefaultMetricFrom".equals(methodName)) continue;
            overridesDefaultMetricFrom = ParsingUtils.readClassToEnum((MethodDeclaration)methodDeclaration);
        }
        return new MetricEntry(name, myEnum.getCanonicalName(), enumConstant.getName(), description, prefix, baseUnit, type, lowCardinalityTags, highCardinalityTags, overridesDefaultMetricFrom);
    }
}

