/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.docs.metrics;

import com.github.jknack.handlebars.Handlebars;
import com.github.jknack.handlebars.Template;
import io.micrometer.common.util.internal.logging.InternalLogger;
import io.micrometer.common.util.internal.logging.InternalLoggerFactory;
import io.micrometer.docs.commons.ObservationConventionEntry;
import io.micrometer.docs.commons.templates.HandlebarsUtils;
import io.micrometer.docs.metrics.MetricEntry;
import io.micrometer.docs.metrics.MetricSearchingFileVisitor;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.TreeSet;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class DocsFromSources {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(DocsFromSources.class);
    private final File projectRoot;
    private final Pattern inclusionPattern;
    private final File outputDir;

    public DocsFromSources(File projectRoot, Pattern inclusionPattern, File outputDir) {
        this.projectRoot = projectRoot;
        this.inclusionPattern = inclusionPattern;
        this.outputDir = outputDir;
    }

    public static void main(String ... args) {
        String projectRoot = args[0];
        String inclusionPattern = args[1];
        inclusionPattern = inclusionPattern.replace("/", File.separator);
        String output = args[2];
        new DocsFromSources(new File(projectRoot), Pattern.compile(inclusionPattern), new File(output)).generate();
    }

    public void generate() {
        Path path = this.projectRoot.toPath();
        logger.debug("Path is [" + this.projectRoot.getAbsolutePath() + "]. Inclusion pattern is [" + this.inclusionPattern + "]");
        TreeSet<MetricEntry> entries = new TreeSet<MetricEntry>();
        TreeSet<ObservationConventionEntry> observationConventionEntries = new TreeSet<ObservationConventionEntry>();
        MetricSearchingFileVisitor fv = new MetricSearchingFileVisitor(this.inclusionPattern, entries, observationConventionEntries);
        try {
            Files.walkFileTree(path, fv);
            MetricEntry.assertThatProperlyPrefixed(entries);
            this.outputDir.mkdirs();
            this.printMetricsAdoc(entries);
            this.printObservationConventionsAdoc(observationConventionEntries);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private void printMetricsAdoc(Collection<MetricEntry> entries) throws IOException {
        String location = "templates/metrics.adoc.hbs";
        Handlebars handlebars = HandlebarsUtils.createHandlebars();
        Template template = handlebars.compile(location);
        HashMap<String, Collection<MetricEntry>> map = new HashMap<String, Collection<MetricEntry>>();
        map.put("entries", entries);
        String result = template.apply(map);
        Path output = new File(this.outputDir, "_metrics.adoc").toPath();
        Files.write(output, result.getBytes(), new OpenOption[0]);
    }

    private void printObservationConventionsAdoc(TreeSet<ObservationConventionEntry> entries) throws IOException {
        List globals = entries.stream().filter(e -> e.getType() == ObservationConventionEntry.Type.GLOBAL).collect(Collectors.toList());
        List locals = entries.stream().filter(e -> e.getType() == ObservationConventionEntry.Type.LOCAL).collect(Collectors.toList());
        String location = "templates/conventions.adoc.hbs";
        Handlebars handlebars = HandlebarsUtils.createHandlebars();
        Template template = handlebars.compile(location);
        HashMap map = new HashMap();
        map.put("globals", globals);
        map.put("locals", locals);
        String result = template.apply(map);
        Path output = new File(this.outputDir, "_conventions.adoc").toPath();
        Files.write(output, result.getBytes(), new OpenOption[0]);
    }
}

