/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.docs.metrics;

import io.micrometer.core.instrument.Meter;
import io.micrometer.docs.commons.KeyValueEntry;
import io.micrometer.docs.commons.utils.Assert;
import io.micrometer.docs.commons.utils.StringUtils;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

class MetricEntry
implements Comparable<MetricEntry> {
    final String name;
    final String conventionClass;
    final String nameFromConventionClass;
    final String enclosingClass;
    final String enumName;
    final String description;
    final String prefix;
    final String baseUnit;
    final Meter.Type type;
    final Collection<KeyValueEntry> lowCardinalityKeyNames;
    final Collection<KeyValueEntry> highCardinalityKeyNames;
    final Map.Entry<String, String> overridesDefaultMetricFrom;
    final Collection<MetricEntry> events;

    MetricEntry(String name, String conventionClass, String nameFromConventionClass, String enclosingClass, String enumName, String description, String prefix, String baseUnit, Meter.Type meterType, Collection<KeyValueEntry> lowCardinalityKeyNames, Collection<KeyValueEntry> highCardinalityKeyNames, Map.Entry<String, String> overridesDefaultMetricFrom, Collection<MetricEntry> events) {
        Assert.hasText((String)description, (String)("Observation / Meter javadoc description must not be empty. Check <" + enclosingClass + "#" + enumName + ">"));
        this.name = name;
        this.conventionClass = conventionClass;
        this.nameFromConventionClass = nameFromConventionClass;
        this.enclosingClass = enclosingClass;
        this.enumName = enumName;
        this.description = description;
        this.prefix = prefix;
        this.baseUnit = StringUtils.hasText((String)baseUnit) ? baseUnit : (meterType == Meter.Type.TIMER ? "seconds" : "");
        this.type = meterType;
        this.lowCardinalityKeyNames = lowCardinalityKeyNames;
        this.highCardinalityKeyNames = highCardinalityKeyNames;
        this.overridesDefaultMetricFrom = overridesDefaultMetricFrom;
        if (StringUtils.hasText((String)this.name) && this.conventionClass != null) {
            throw new IllegalStateException("You can't declare both [getName()] and [getDefaultConvention()] methods at the same time, you have to chose only one. Problem occurred in [" + this.enclosingClass + "] class");
        }
        if (this.name == null && this.conventionClass == null) {
            throw new IllegalStateException("You have to set either [getName()] or [getDefaultConvention()] methods. In case of [" + this.enclosingClass + "] you haven't defined any");
        }
        this.events = events;
    }

    static void assertThatProperlyPrefixed(Collection<MetricEntry> entries) {
        List collect = entries.stream().map(MetricEntry::notProperlyPrefixedTags).filter(Objects::nonNull).collect(Collectors.toList());
        if (collect.isEmpty()) {
            return;
        }
        throw new IllegalStateException("The following documented objects do not have properly prefixed tag keys according to their prefix() method. Please align the tag keys.\n\n" + collect.stream().map(e -> "\tName <" + ((MetricEntry)e.getKey()).enumName + "> in class <" + ((MetricEntry)e.getKey()).enclosingClass + "> has the following prefix <" + ((MetricEntry)e.getKey()).prefix + "> and following invalid tag keys " + e.getValue()).collect(Collectors.joining("\n")) + "\n\n");
    }

    Map.Entry<MetricEntry, List<String>> notProperlyPrefixedTags() {
        if (!StringUtils.hasText((String)this.prefix)) {
            return null;
        }
        ArrayList<KeyValueEntry> allTags = new ArrayList<KeyValueEntry>(this.lowCardinalityKeyNames);
        allTags.addAll(this.highCardinalityKeyNames);
        List collect = allTags.stream().map(KeyValueEntry::getName).filter(eName -> !eName.startsWith(this.prefix)).collect(Collectors.toList());
        if (collect.isEmpty()) {
            return null;
        }
        return new AbstractMap.SimpleEntry<MetricEntry, List<String>>(this, collect);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MetricEntry that = (MetricEntry)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.conventionClass, that.conventionClass) && Objects.equals(this.nameFromConventionClass, that.nameFromConventionClass) && Objects.equals(this.enclosingClass, that.enclosingClass) && Objects.equals(this.enumName, that.enumName) && Objects.equals(this.description, that.description) && Objects.equals(this.prefix, that.prefix) && Objects.equals(this.baseUnit, that.baseUnit) && this.type == that.type && Objects.equals(this.lowCardinalityKeyNames, that.lowCardinalityKeyNames) && Objects.equals(this.highCardinalityKeyNames, that.highCardinalityKeyNames) && Objects.equals(this.overridesDefaultMetricFrom, that.overridesDefaultMetricFrom);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.conventionClass, this.nameFromConventionClass, this.enclosingClass, this.enumName, this.description, this.prefix, this.baseUnit, this.type, this.lowCardinalityKeyNames, this.highCardinalityKeyNames, this.overridesDefaultMetricFrom);
    }

    @Override
    public int compareTo(MetricEntry o) {
        return this.enumName.compareTo(o.enumName);
    }

    private String name() {
        if (StringUtils.hasText((String)this.name)) {
            return "`" + this.name + "`";
        }
        if (StringUtils.hasText((String)this.nameFromConventionClass)) {
            return "`" + this.nameFromConventionClass + "` (defined by convention class `" + this.conventionClass + "`)";
        }
        return "Unable to resolve the name - please check the convention class `" + this.conventionClass + "` for more details";
    }

    public String getDescription() {
        return this.description;
    }

    public String getMetricName() {
        return this.name();
    }

    public String getName() {
        return this.name;
    }

    public String getEnumName() {
        return this.enumName;
    }

    public Meter.Type getType() {
        return this.type;
    }

    public String getBaseUnit() {
        return this.baseUnit;
    }

    public String getEnclosingClass() {
        return this.enclosingClass;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public Collection<KeyValueEntry> getLowCardinalityKeyNames() {
        return this.lowCardinalityKeyNames;
    }

    public Collection<KeyValueEntry> getHighCardinalityKeyNames() {
        return this.highCardinalityKeyNames;
    }

    public Collection<MetricEntry> getEvents() {
        return this.events;
    }
}

