/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.docs.metrics;

import io.micrometer.common.docs.KeyName;
import io.micrometer.common.util.internal.logging.InternalLogger;
import io.micrometer.common.util.internal.logging.InternalLoggerFactory;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.docs.MeterDocumentation;
import io.micrometer.docs.commons.KeyValueEntry;
import io.micrometer.docs.commons.ObservationConventionEntry;
import io.micrometer.docs.commons.ParsingUtils;
import io.micrometer.docs.commons.utils.AsciidocUtils;
import io.micrometer.docs.metrics.MetricEntry;
import io.micrometer.observation.GlobalObservationConvention;
import io.micrometer.observation.Observation;
import io.micrometer.observation.ObservationConvention;
import io.micrometer.observation.docs.ObservationDocumentation;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jboss.forge.roaster.Roaster;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.MethodDeclaration;
import org.jboss.forge.roaster.model.JavaType;
import org.jboss.forge.roaster.model.JavaUnit;
import org.jboss.forge.roaster.model.impl.JavaClassImpl;
import org.jboss.forge.roaster.model.impl.JavaEnumImpl;
import org.jboss.forge.roaster.model.source.EnumConstantSource;
import org.jboss.forge.roaster.model.source.JavaDocSource;
import org.jboss.forge.roaster.model.source.MemberSource;

class MetricSearchingFileVisitor
extends SimpleFileVisitor<Path> {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(MetricSearchingFileVisitor.class);
    private final Pattern pattern;
    private final Collection<MetricEntry> sampleEntries;
    private final Collection<ObservationConventionEntry> observationConventionEntries;

    MetricSearchingFileVisitor(Pattern pattern, Collection<MetricEntry> sampleEntries, Collection<ObservationConventionEntry> observationConventionEntries) {
        this.pattern = pattern;
        this.sampleEntries = sampleEntries;
        this.observationConventionEntries = observationConventionEntries;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
        if (!this.pattern.matcher(file.toString()).matches()) {
            return FileVisitResult.CONTINUE;
        }
        if (!file.toString().endsWith(".java")) {
            return FileVisitResult.CONTINUE;
        }
        try {
            JavaType myClass;
            JavaUnit unit;
            block25: {
                InputStream stream = Files.newInputStream(file, new OpenOption[0]);
                unit = Roaster.parseUnit((InputStream)stream);
                myClass = unit.getGoverningType();
                if (!(myClass instanceof JavaEnumImpl)) {
                    if (!(myClass instanceof JavaClassImpl)) {
                        FileVisitResult classPattern = FileVisitResult.CONTINUE;
                        return classPattern;
                    }
                    break block25;
                } else {
                    JavaEnumImpl myEnum = (JavaEnumImpl)myClass;
                    if (Stream.of(MeterDocumentation.class.getCanonicalName(), ObservationDocumentation.class.getCanonicalName()).noneMatch(ds -> myEnum.getInterfaces().contains(ds))) {
                        FileVisitResult fileVisitResult = FileVisitResult.CONTINUE;
                        return fileVisitResult;
                    }
                    logger.debug("Checking [" + myEnum.getName() + "]");
                    if (myEnum.getEnumConstants().size() == 0) {
                        FileVisitResult fileVisitResult = FileVisitResult.CONTINUE;
                        return fileVisitResult;
                    }
                    for (EnumConstantSource enumConstant : myEnum.getEnumConstants()) {
                        MetricEntry entry = this.parseMetric(file, enumConstant, myEnum);
                        if (entry != null) {
                            this.sampleEntries.add(entry);
                            logger.debug("Found [" + entry.lowCardinalityKeyNames.size() + "] low cardinality tags and [" + entry.highCardinalityKeyNames.size() + "] high cardinality tags");
                        }
                        if (entry == null) continue;
                        if (entry.overridesDefaultMetricFrom != null && entry.lowCardinalityKeyNames.isEmpty()) {
                            this.addTagsFromOverride(file, entry);
                        }
                        this.sampleEntries.add(entry);
                        logger.debug("Found [" + entry.lowCardinalityKeyNames.size() + "]");
                    }
                    Object object = FileVisitResult.CONTINUE;
                    return object;
                }
                finally {
                    if (stream != null) {
                        stream.close();
                    }
                }
            }
            Pattern classPattern = Pattern.compile("^.*ObservationConvention<(.*)>$");
            JavaClassImpl holder = (JavaClassImpl)myClass;
            Object object = holder.getInterfaces().iterator();
            while (true) {
                if (!object.hasNext()) {
                    object = FileVisitResult.CONTINUE;
                    return object;
                }
                String anInterface = (String)object.next();
                if (this.isGlobalObservationConvention(anInterface)) {
                    this.observationConventionEntries.add(new ObservationConventionEntry(unit.getGoverningType().getCanonicalName(), ObservationConventionEntry.Type.GLOBAL, this.contextClassName(classPattern, anInterface)));
                    continue;
                }
                if (!this.isLocalObservationConvention(anInterface)) continue;
                this.observationConventionEntries.add(new ObservationConventionEntry(unit.getGoverningType().getCanonicalName(), ObservationConventionEntry.Type.LOCAL, this.contextClassName(classPattern, anInterface)));
            }
        }
        catch (Exception e) {
            throw new IOException("Failed to parse file [" + file + "] due to an error", e);
        }
    }

    private String contextClassName(Pattern classPattern, String anInterface) {
        Matcher matcher = classPattern.matcher(anInterface);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        if (!anInterface.contains("<") && !anInterface.contains(">")) {
            return "n/a";
        }
        return "";
    }

    private boolean isLocalObservationConvention(String interf) {
        return interf.contains(ObservationConvention.class.getSimpleName()) || interf.contains(ObservationConvention.class.getCanonicalName());
    }

    private boolean isGlobalObservationConvention(String interf) {
        return interf.contains(GlobalObservationConvention.class.getSimpleName()) || interf.contains(GlobalObservationConvention.class.getCanonicalName());
    }

    private void addTagsFromOverride(Path file, MetricEntry entry) throws IOException {
        Map.Entry<String, String> overrideDefaults = entry.overridesDefaultMetricFrom;
        logger.debug("Reading additional meta data from [" + overrideDefaults + "]");
        String className = overrideDefaults.getKey();
        File parent = file.getParent().toFile();
        while (!parent.getAbsolutePath().endsWith(File.separator + "java")) {
            parent = parent.getParentFile();
        }
        String filePath = new File(parent, className.replace(".", File.separator) + ".java").getAbsolutePath();
        try (InputStream streamForOverride = Files.newInputStream(new File(filePath).toPath(), new OpenOption[0]);){
            JavaUnit parsedForOverride = Roaster.parseUnit((InputStream)streamForOverride);
            JavaType overrideClass = parsedForOverride.getGoverningType();
            if (!(overrideClass instanceof JavaEnumImpl)) {
                return;
            }
            JavaEnumImpl myEnum = (JavaEnumImpl)overrideClass;
            if (!myEnum.getInterfaces().contains(ObservationDocumentation.class.getCanonicalName())) {
                return;
            }
            logger.debug("Checking [" + myEnum.getName() + "]");
            if (myEnum.getEnumConstants().size() == 0) {
                return;
            }
            for (EnumConstantSource enumConstant : myEnum.getEnumConstants()) {
                Collection low;
                if (!enumConstant.getName().equals(overrideDefaults.getValue()) || (low = ParsingUtils.getTags((EnumConstantSource)enumConstant, (JavaEnumImpl)myEnum, (String)"getLowCardinalityKeyNames")) == null) continue;
                entry.lowCardinalityKeyNames.addAll(low);
            }
        }
    }

    private MetricEntry parseMetric(Path file, EnumConstantSource enumConstant, JavaEnumImpl myEnum) {
        List members = enumConstant.getBody().getMembers();
        if (members.isEmpty()) {
            return null;
        }
        String name = "";
        String description = AsciidocUtils.javadocToAsciidoc((JavaDocSource)enumConstant.getJavaDoc());
        String prefix = "";
        String baseUnit = "";
        Meter.Type type = Meter.Type.TIMER;
        TreeSet<KeyValueEntry> lowCardinalityTags = new TreeSet<KeyValueEntry>();
        TreeSet<KeyValueEntry> highCardinalityTags = new TreeSet<KeyValueEntry>();
        Map.Entry overridesDefaultMetricFrom = null;
        String conventionClass = null;
        String nameFromConventionClass = null;
        ArrayList<MetricEntry> events = new ArrayList();
        for (MemberSource member : members) {
            Object internal = member.getInternal();
            if (!(internal instanceof MethodDeclaration)) {
                return null;
            }
            MethodDeclaration methodDeclaration = (MethodDeclaration)internal;
            String methodName = methodDeclaration.getName().getIdentifier();
            if ("getName".equals(methodName)) {
                name = ParsingUtils.readStringReturnValue((MethodDeclaration)methodDeclaration);
                continue;
            }
            if ("getKeyNames".equals(methodName)) {
                lowCardinalityTags.addAll(ParsingUtils.keyValueEntries((JavaEnumImpl)myEnum, (MethodDeclaration)methodDeclaration, KeyName.class));
                continue;
            }
            if ("getDefaultConvention".equals(methodName)) {
                conventionClass = ParsingUtils.readClass((MethodDeclaration)methodDeclaration);
                nameFromConventionClass = ParsingUtils.tryToReadStringReturnValue((Path)file, (String)conventionClass);
                continue;
            }
            if ("getLowCardinalityKeyNames".equals(methodName) || "asString".equals(methodName)) {
                lowCardinalityTags.addAll(ParsingUtils.keyValueEntries((JavaEnumImpl)myEnum, (MethodDeclaration)methodDeclaration, KeyName.class));
                continue;
            }
            if ("getHighCardinalityKeyNames".equals(methodName)) {
                highCardinalityTags.addAll(ParsingUtils.keyValueEntries((JavaEnumImpl)myEnum, (MethodDeclaration)methodDeclaration, KeyName.class));
                continue;
            }
            if ("getPrefix".equals(methodName)) {
                prefix = ParsingUtils.readStringReturnValue((MethodDeclaration)methodDeclaration);
                continue;
            }
            if ("getBaseUnit".equals(methodName)) {
                baseUnit = ParsingUtils.readStringReturnValue((MethodDeclaration)methodDeclaration);
                continue;
            }
            if ("getType".equals(methodName)) {
                type = (Meter.Type)ParsingUtils.enumFromReturnMethodDeclaration((MethodDeclaration)methodDeclaration, Meter.Type.class);
                continue;
            }
            if ("getDescription".equals(methodName)) {
                description = ParsingUtils.readStringReturnValue((MethodDeclaration)methodDeclaration);
                continue;
            }
            if ("overridesDefaultMetricFrom".equals(methodName)) {
                overridesDefaultMetricFrom = ParsingUtils.readClassToEnum((MethodDeclaration)methodDeclaration);
                continue;
            }
            if (!"getEvents".equals(methodName)) continue;
            Collection entries = ParsingUtils.keyValueEntries((JavaEnumImpl)myEnum, (MethodDeclaration)methodDeclaration, Observation.Event.class, (String)"getName");
            Collection counters = entries.stream().map(k -> new MetricEntry(k.getName(), null, null, myEnum.getCanonicalName(), enumConstant.getName(), k.getDescription(), null, null, Meter.Type.COUNTER, new TreeSet<KeyValueEntry>(), new TreeSet<KeyValueEntry>(), null, new TreeSet<MetricEntry>())).collect(Collectors.toList());
            events.addAll(counters);
        }
        String newName = name;
        events = events.stream().map(m -> new MetricEntry(newName + "." + m.name, m.conventionClass, m.nameFromConventionClass, m.enclosingClass, m.enumName, m.description, m.prefix, m.baseUnit, m.type, m.lowCardinalityKeyNames, m.highCardinalityKeyNames, m.overridesDefaultMetricFrom, m.events)).collect(Collectors.toList());
        return new MetricEntry(name, conventionClass, nameFromConventionClass, myEnum.getCanonicalName(), enumConstant.getName(), description, prefix, baseUnit, type, lowCardinalityTags, highCardinalityTags, overridesDefaultMetricFrom, events);
    }
}

