/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.cassandra;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.QueryOptions;
import com.datastax.driver.core.SocketOptions;
import com.datastax.driver.core.policies.LoadBalancingPolicy;
import com.datastax.driver.core.policies.ReconnectionPolicy;
import com.datastax.driver.core.policies.RetryPolicy;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.cassandra.CassandraProperties;
import org.springframework.boot.autoconfigure.cassandra.ClusterBuilderCustomizer;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.StringUtils;

@Configuration
@ConditionalOnClass(value={Cluster.class})
@EnableConfigurationProperties(value={CassandraProperties.class})
public class CassandraAutoConfiguration {
    private final CassandraProperties properties;
    private final List<ClusterBuilderCustomizer> builderCustomizers;

    public CassandraAutoConfiguration(CassandraProperties properties, ObjectProvider<List<ClusterBuilderCustomizer>> builderCustomizers) {
        this.properties = properties;
        this.builderCustomizers = (List)builderCustomizers.getIfAvailable();
    }

    @Bean
    @ConditionalOnMissingBean
    public Cluster cassandraCluster() {
        LoadBalancingPolicy policy;
        CassandraProperties properties = this.properties;
        Cluster.Builder builder = Cluster.builder().withClusterName(properties.getClusterName()).withPort(properties.getPort());
        if (properties.getUsername() != null) {
            builder.withCredentials(properties.getUsername(), properties.getPassword());
        }
        if (properties.getCompression() != null) {
            builder.withCompression(properties.getCompression());
        }
        if (properties.getLoadBalancingPolicy() != null) {
            policy = CassandraAutoConfiguration.instantiate(properties.getLoadBalancingPolicy());
            builder.withLoadBalancingPolicy(policy);
        }
        builder.withQueryOptions(this.getQueryOptions());
        if (properties.getReconnectionPolicy() != null) {
            policy = CassandraAutoConfiguration.instantiate(properties.getReconnectionPolicy());
            builder.withReconnectionPolicy((ReconnectionPolicy)policy);
        }
        if (properties.getRetryPolicy() != null) {
            policy = CassandraAutoConfiguration.instantiate(properties.getRetryPolicy());
            builder.withRetryPolicy((RetryPolicy)policy);
        }
        builder.withSocketOptions(this.getSocketOptions());
        if (properties.isSsl()) {
            builder.withSSL();
        }
        String points = properties.getContactPoints();
        builder.addContactPoints(StringUtils.commaDelimitedListToStringArray((String)points));
        this.customize(builder);
        return builder.build();
    }

    private void customize(Cluster.Builder builder) {
        if (this.builderCustomizers != null) {
            for (ClusterBuilderCustomizer customizer : this.builderCustomizers) {
                customizer.customize(builder);
            }
        }
    }

    public static <T> T instantiate(Class<T> type) {
        return (T)BeanUtils.instantiateClass(type);
    }

    private QueryOptions getQueryOptions() {
        QueryOptions options = new QueryOptions();
        CassandraProperties properties = this.properties;
        if (properties.getConsistencyLevel() != null) {
            options.setConsistencyLevel(properties.getConsistencyLevel());
        }
        if (properties.getSerialConsistencyLevel() != null) {
            options.setSerialConsistencyLevel(properties.getSerialConsistencyLevel());
        }
        options.setFetchSize(properties.getFetchSize());
        return options;
    }

    private SocketOptions getSocketOptions() {
        SocketOptions options = new SocketOptions();
        options.setConnectTimeoutMillis(this.properties.getConnectTimeoutMillis());
        options.setReadTimeoutMillis(this.properties.getReadTimeoutMillis());
        return options;
    }
}

