/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.data.redis;

import java.net.UnknownHostException;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.data.redis.RedisConnectionConfiguration;
import org.springframework.boot.autoconfigure.data.redis.RedisProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.connection.RedisClusterConfiguration;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.RedisSentinelConfiguration;
import org.springframework.data.redis.connection.jedis.JedisConnection;
import org.springframework.data.redis.connection.jedis.JedisConnectionFactory;
import org.springframework.util.StringUtils;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPoolConfig;

@Configuration
@ConditionalOnClass(value={GenericObjectPool.class, JedisConnection.class, Jedis.class})
class JedisConnectionConfiguration
extends RedisConnectionConfiguration {
    private final RedisProperties properties;

    JedisConnectionConfiguration(RedisProperties properties, ObjectProvider<RedisSentinelConfiguration> sentinelConfiguration, ObjectProvider<RedisClusterConfiguration> clusterConfiguration) {
        super(properties, sentinelConfiguration, clusterConfiguration);
        this.properties = properties;
    }

    @Bean
    @ConditionalOnMissingBean(value={RedisConnectionFactory.class})
    public JedisConnectionFactory redisConnectionFactory() throws UnknownHostException {
        return this.applyProperties(this.createJedisConnectionFactory());
    }

    private JedisConnectionFactory applyProperties(JedisConnectionFactory factory) {
        this.configureConnection(factory);
        if (this.properties.isSsl()) {
            factory.setUseSsl(true);
        }
        factory.setDatabase(this.properties.getDatabase());
        if (this.properties.getTimeout() > 0) {
            factory.setTimeout(this.properties.getTimeout());
        }
        return factory;
    }

    private void configureConnection(JedisConnectionFactory factory) {
        if (StringUtils.hasText((String)this.properties.getUrl())) {
            this.configureConnectionFromUrl(factory);
        } else {
            factory.setHostName(this.properties.getHost());
            factory.setPort(this.properties.getPort());
            if (this.properties.getPassword() != null) {
                factory.setPassword(this.properties.getPassword());
            }
        }
    }

    private void configureConnectionFromUrl(JedisConnectionFactory factory) {
        RedisConnectionConfiguration.ConnectionInfo connectionInfo = this.parseUrl(this.properties.getUrl());
        factory.setUseSsl(connectionInfo.isUseSsl());
        factory.setHostName(connectionInfo.getHostName());
        factory.setPort(connectionInfo.getPort());
        if (connectionInfo.getPassword() != null) {
            factory.setPassword(connectionInfo.getPassword());
        }
    }

    private JedisConnectionFactory createJedisConnectionFactory() {
        JedisPoolConfig poolConfig;
        RedisProperties.Pool pool = this.properties.getJedis().getPool();
        JedisPoolConfig jedisPoolConfig = poolConfig = pool != null ? this.jedisPoolConfig(pool) : new JedisPoolConfig();
        if (this.getSentinelConfig() != null) {
            return new JedisConnectionFactory(this.getSentinelConfig(), poolConfig);
        }
        if (this.getClusterConfiguration() != null) {
            return new JedisConnectionFactory(this.getClusterConfiguration(), poolConfig);
        }
        return new JedisConnectionFactory(poolConfig);
    }

    private JedisPoolConfig jedisPoolConfig(RedisProperties.Pool pool) {
        JedisPoolConfig config = new JedisPoolConfig();
        config.setMaxTotal(pool.getMaxActive());
        config.setMaxIdle(pool.getMaxIdle());
        config.setMinIdle(pool.getMinIdle());
        config.setMaxWaitMillis((long)pool.getMaxWait());
        return config;
    }
}

