/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.cli.command.init;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.codehaus.plexus.util.StringUtils;
import org.springframework.boot.cli.command.init.Dependency;
import org.springframework.boot.cli.command.init.InitializrService;
import org.springframework.boot.cli.command.init.InitializrServiceMetadata;
import org.springframework.boot.cli.command.init.ProjectType;

class ServiceCapabilitiesReportGenerator {
    private static final String NEW_LINE = System.getProperty("line.separator");
    private final InitializrService initializrService;

    ServiceCapabilitiesReportGenerator(InitializrService initializrService) {
        this.initializrService = initializrService;
    }

    public String generate(String url) throws IOException {
        Object content = this.initializrService.loadServiceCapabilities(url);
        if (content instanceof InitializrServiceMetadata) {
            return this.generateHelp(url, (InitializrServiceMetadata)content);
        }
        return content.toString();
    }

    private String generateHelp(String url, InitializrServiceMetadata metadata) {
        String header = "Capabilities of " + url;
        StringBuilder report = new StringBuilder();
        report.append(StringUtils.repeat((String)"=", (int)header.length()) + NEW_LINE);
        report.append(header + NEW_LINE);
        report.append(StringUtils.repeat((String)"=", (int)header.length()) + NEW_LINE);
        report.append(NEW_LINE);
        this.reportAvailableDependencies(metadata, report);
        report.append(NEW_LINE);
        this.reportAvilableProjectTypes(metadata, report);
        report.append(NEW_LINE);
        this.z(metadata, report);
        return report.toString();
    }

    private void reportAvailableDependencies(InitializrServiceMetadata metadata, StringBuilder report) {
        report.append("Available dependencies:" + NEW_LINE);
        report.append("-----------------------" + NEW_LINE);
        List<Dependency> dependencies = this.getSortedDependencies(metadata);
        for (Dependency dependency : dependencies) {
            report.append(dependency.getId() + " - " + dependency.getName());
            if (dependency.getDescription() != null) {
                report.append(": " + dependency.getDescription());
            }
            report.append(NEW_LINE);
        }
    }

    private List<Dependency> getSortedDependencies(InitializrServiceMetadata metadata) {
        ArrayList<Dependency> dependencies = new ArrayList<Dependency>(metadata.getDependencies());
        Collections.sort(dependencies, new Comparator<Dependency>(){

            @Override
            public int compare(Dependency o1, Dependency o2) {
                return o1.getId().compareTo(o2.getId());
            }
        });
        return dependencies;
    }

    private void reportAvilableProjectTypes(InitializrServiceMetadata metadata, StringBuilder report) {
        report.append("Available project types:" + NEW_LINE);
        report.append("------------------------" + NEW_LINE);
        ArrayList<String> typeIds = new ArrayList<String>(metadata.getProjectTypes().keySet());
        Collections.sort(typeIds);
        for (String typeId : typeIds) {
            ProjectType type = metadata.getProjectTypes().get(typeId);
            report.append(typeId + " -  " + type.getName());
            if (!type.getTags().isEmpty()) {
                this.reportTags(report, type);
            }
            if (type.isDefaultType()) {
                report.append(" (default)");
            }
            report.append(NEW_LINE);
        }
    }

    private void reportTags(StringBuilder report, ProjectType type) {
        Map<String, String> tags = type.getTags();
        Iterator<Map.Entry<String, String>> iterator = tags.entrySet().iterator();
        report.append(" [");
        while (iterator.hasNext()) {
            Map.Entry<String, String> entry = iterator.next();
            report.append(entry.getKey() + ":" + entry.getValue());
            if (!iterator.hasNext()) continue;
            report.append(", ");
        }
        report.append("]");
    }

    private void z(InitializrServiceMetadata metadata, StringBuilder report) {
        report.append("Defaults:" + NEW_LINE);
        report.append("---------" + NEW_LINE);
        ArrayList<String> defaultsKeys = new ArrayList<String>(metadata.getDefaults().keySet());
        Collections.sort(defaultsKeys);
        for (String defaultsKey : defaultsKeys) {
            String defaultsValue = metadata.getDefaults().get(defaultsKey);
            report.append(defaultsKey + ": " + defaultsValue + NEW_LINE);
        }
    }
}

