/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.cli.compiler;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassCodeVisitorSupport;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.GroovyClassVisitor;
import org.codehaus.groovy.ast.ImportNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.transform.ASTTransformation;

public abstract class AnnotatedNodeASTTransformation
implements ASTTransformation {
    private final Set<String> interestingAnnotationNames;
    private final boolean removeAnnotations;
    private List<AnnotationNode> annotationNodes = new ArrayList<AnnotationNode>();
    private SourceUnit sourceUnit;

    protected AnnotatedNodeASTTransformation(Set<String> interestingAnnotationNames, boolean removeAnnotations) {
        this.interestingAnnotationNames = interestingAnnotationNames;
        this.removeAnnotations = removeAnnotations;
    }

    public void visit(ASTNode[] nodes, SourceUnit source) {
        this.sourceUnit = source;
        ClassVisitor classVisitor = new ClassVisitor(source);
        for (ASTNode node : nodes) {
            if (!(node instanceof ModuleNode)) continue;
            ModuleNode module = (ModuleNode)node;
            this.visitAnnotatedNode((AnnotatedNode)module.getPackage());
            for (ImportNode importNode : module.getImports()) {
                this.visitAnnotatedNode((AnnotatedNode)importNode);
            }
            for (ImportNode importNode : module.getStarImports()) {
                this.visitAnnotatedNode((AnnotatedNode)importNode);
            }
            for (Map.Entry entry : module.getStaticImports().entrySet()) {
                this.visitAnnotatedNode((AnnotatedNode)entry.getValue());
            }
            for (Map.Entry entry : module.getStaticStarImports().entrySet()) {
                this.visitAnnotatedNode((AnnotatedNode)entry.getValue());
            }
            for (ClassNode classNode : module.getClasses()) {
                this.visitAnnotatedNode((AnnotatedNode)classNode);
                classNode.visitContents((GroovyClassVisitor)classVisitor);
            }
        }
        this.processAnnotationNodes(this.annotationNodes);
    }

    protected SourceUnit getSourceUnit() {
        return this.sourceUnit;
    }

    protected abstract void processAnnotationNodes(List<AnnotationNode> var1);

    private void visitAnnotatedNode(AnnotatedNode annotatedNode) {
        if (annotatedNode != null) {
            Iterator annotationNodes = annotatedNode.getAnnotations().iterator();
            while (annotationNodes.hasNext()) {
                AnnotationNode annotationNode = (AnnotationNode)annotationNodes.next();
                if (!this.interestingAnnotationNames.contains(annotationNode.getClassNode().getName())) continue;
                this.annotationNodes.add(annotationNode);
                if (!this.removeAnnotations) continue;
                annotationNodes.remove();
            }
        }
    }

    private class ClassVisitor
    extends ClassCodeVisitorSupport {
        private final SourceUnit source;

        public ClassVisitor(SourceUnit source) {
            this.source = source;
        }

        protected SourceUnit getSourceUnit() {
            return this.source;
        }

        public void visitAnnotations(AnnotatedNode node) {
            AnnotatedNodeASTTransformation.this.visitAnnotatedNode(node);
        }
    }
}

