/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.cli.compiler.autoconfigure;

import groovy.lang.GroovyClassLoader;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.classgen.GeneratorContext;
import org.codehaus.groovy.control.CompilationFailedException;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.control.customizers.ImportCustomizer;
import org.springframework.boot.cli.compiler.CompilerAutoConfiguration;
import org.springframework.boot.cli.compiler.DependencyCustomizer;
import org.springframework.boot.cli.compiler.GroovyCompilerConfiguration;

public class SpringBootCompilerAutoConfiguration
extends CompilerAutoConfiguration {
    public void applyDependencies(DependencyCustomizer dependencies) {
        dependencies.ifAnyMissingClasses(new String[]{"org.springframework.boot.SpringApplication"}).add(new String[]{"spring-boot-starter"});
    }

    public void applyImports(ImportCustomizer imports) {
        imports.addImports(new String[]{"jakarta.annotation.PostConstruct", "jakarta.annotation.PreDestroy", "groovy.util.logging.Log", "org.springframework.stereotype.Controller", "org.springframework.stereotype.Service", "org.springframework.stereotype.Component", "org.springframework.beans.factory.annotation.Autowired", "org.springframework.beans.factory.annotation.Value", "org.springframework.context.annotation.Import", "org.springframework.context.annotation.ImportResource", "org.springframework.context.annotation.Profile", "org.springframework.context.annotation.Scope", "org.springframework.context.annotation.Configuration", "org.springframework.context.annotation.ComponentScan", "org.springframework.context.annotation.Bean", "org.springframework.context.ApplicationContext", "org.springframework.context.MessageSource", "org.springframework.core.annotation.Order", "org.springframework.core.io.ResourceLoader", "org.springframework.boot.ApplicationRunner", "org.springframework.boot.ApplicationArguments", "org.springframework.boot.CommandLineRunner", "org.springframework.boot.context.properties.ConfigurationProperties", "org.springframework.boot.context.properties.EnableConfigurationProperties", "org.springframework.boot.autoconfigure.EnableAutoConfiguration", "org.springframework.boot.autoconfigure.SpringBootApplication", "org.springframework.boot.context.properties.ConfigurationProperties", "org.springframework.boot.context.properties.EnableConfigurationProperties"});
        imports.addStarImports(new String[]{"org.springframework.stereotype", "org.springframework.scheduling.annotation"});
    }

    public void applyToMainClass(GroovyClassLoader loader, GroovyCompilerConfiguration configuration, GeneratorContext generatorContext, SourceUnit source, ClassNode classNode) throws CompilationFailedException {
        this.addEnableAutoConfigurationAnnotation(classNode);
    }

    private void addEnableAutoConfigurationAnnotation(ClassNode classNode) {
        if (!this.hasEnableAutoConfigureAnnotation(classNode)) {
            AnnotationNode annotationNode = new AnnotationNode(ClassHelper.make((String)"EnableAutoConfiguration"));
            classNode.addAnnotation(annotationNode);
        }
    }

    private boolean hasEnableAutoConfigureAnnotation(ClassNode classNode) {
        for (AnnotationNode node : classNode.getAnnotations()) {
            String name = node.getClassNode().getNameWithoutPackage();
            if (!"EnableAutoConfiguration".equals(name) && !"SpringBootApplication".equals(name)) continue;
            return true;
        }
        return false;
    }
}

