/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.cli.compiler.maven;

import java.io.BufferedReader;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.maven.model.ActivationFile;
import org.apache.maven.model.ActivationOS;
import org.apache.maven.model.ActivationProperty;
import org.apache.maven.model.Profile;
import org.apache.maven.model.building.ModelProblemCollector;
import org.apache.maven.model.building.ModelProblemCollectorRequest;
import org.apache.maven.model.path.DefaultPathTranslator;
import org.apache.maven.model.path.PathTranslator;
import org.apache.maven.model.profile.DefaultProfileSelector;
import org.apache.maven.model.profile.ProfileActivationContext;
import org.apache.maven.model.profile.activation.FileProfileActivator;
import org.apache.maven.model.profile.activation.JdkVersionProfileActivator;
import org.apache.maven.model.profile.activation.OperatingSystemProfileActivator;
import org.apache.maven.model.profile.activation.ProfileActivator;
import org.apache.maven.model.profile.activation.PropertyProfileActivator;
import org.apache.maven.settings.Activation;
import org.apache.maven.settings.Mirror;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.apache.maven.settings.crypto.SettingsDecryptionResult;
import org.eclipse.aether.repository.Authentication;
import org.eclipse.aether.repository.AuthenticationSelector;
import org.eclipse.aether.repository.MirrorSelector;
import org.eclipse.aether.repository.Proxy;
import org.eclipse.aether.repository.ProxySelector;
import org.eclipse.aether.util.repository.AuthenticationBuilder;
import org.eclipse.aether.util.repository.ConservativeAuthenticationSelector;
import org.eclipse.aether.util.repository.DefaultAuthenticationSelector;
import org.eclipse.aether.util.repository.DefaultMirrorSelector;
import org.eclipse.aether.util.repository.DefaultProxySelector;
import org.springframework.boot.cli.compiler.maven.MavenSettings;

public class MavenSettings {
    private final boolean offline;
    private final MirrorSelector mirrorSelector;
    private final AuthenticationSelector authenticationSelector;
    private final ProxySelector proxySelector;
    private final String localRepository;
    private final List<org.apache.maven.settings.Profile> activeProfiles;

    public MavenSettings(Settings settings, SettingsDecryptionResult decryptedSettings) {
        this.offline = settings.isOffline();
        this.mirrorSelector = this.createMirrorSelector(settings);
        this.authenticationSelector = this.createAuthenticationSelector(decryptedSettings);
        this.proxySelector = this.createProxySelector(decryptedSettings);
        this.localRepository = settings.getLocalRepository();
        this.activeProfiles = this.determineActiveProfiles(settings);
    }

    private MirrorSelector createMirrorSelector(Settings settings) {
        DefaultMirrorSelector selector = new DefaultMirrorSelector();
        for (Mirror mirror : settings.getMirrors()) {
            selector.add(mirror.getId(), mirror.getUrl(), mirror.getLayout(), false, mirror.getMirrorOf(), mirror.getMirrorOfLayouts());
        }
        return selector;
    }

    private AuthenticationSelector createAuthenticationSelector(SettingsDecryptionResult decryptedSettings) {
        DefaultAuthenticationSelector selector = new DefaultAuthenticationSelector();
        for (Server server : decryptedSettings.getServers()) {
            AuthenticationBuilder auth = new AuthenticationBuilder();
            auth.addUsername(server.getUsername()).addPassword(server.getPassword());
            auth.addPrivateKey(server.getPrivateKey(), server.getPassphrase());
            selector.add(server.getId(), auth.build());
        }
        return new ConservativeAuthenticationSelector((AuthenticationSelector)selector);
    }

    private ProxySelector createProxySelector(SettingsDecryptionResult decryptedSettings) {
        DefaultProxySelector selector = new DefaultProxySelector();
        for (org.apache.maven.settings.Proxy proxy : decryptedSettings.getProxies()) {
            Authentication authentication = new AuthenticationBuilder().addUsername(proxy.getUsername()).addPassword(proxy.getPassword()).build();
            selector.add(new Proxy(proxy.getProtocol(), proxy.getHost(), proxy.getPort(), authentication), proxy.getNonProxyHosts());
        }
        return selector;
    }

    private List<org.apache.maven.settings.Profile> determineActiveProfiles(Settings settings) {
        SpringBootCliModelProblemCollector problemCollector = new SpringBootCliModelProblemCollector();
        List activeModelProfiles = this.createProfileSelector().getActiveProfiles((Collection)this.createModelProfiles(settings.getProfiles()), (ProfileActivationContext)new SpringBootCliProfileActivationContext(settings.getActiveProfiles()), (ModelProblemCollector)problemCollector);
        if (!problemCollector.getProblems().isEmpty()) {
            throw new IllegalStateException(this.createFailureMessage(problemCollector));
        }
        ArrayList<org.apache.maven.settings.Profile> activeProfiles = new ArrayList<org.apache.maven.settings.Profile>();
        Map profiles = settings.getProfilesAsMap();
        for (Profile modelProfile : activeModelProfiles) {
            activeProfiles.add((org.apache.maven.settings.Profile)profiles.get(modelProfile.getId()));
        }
        return activeProfiles;
    }

    private String createFailureMessage(SpringBootCliModelProblemCollector problemCollector) {
        StringWriter message = new StringWriter();
        PrintWriter printer = new PrintWriter(message);
        printer.println("Failed to determine active profiles:");
        for (ModelProblemCollectorRequest problem : problemCollector.getProblems()) {
            String location = problem.getLocation() != null ? " at " + problem.getLocation() : "";
            printer.println("    " + problem.getMessage() + location);
            if (problem.getException() == null) continue;
            printer.println(this.indentStackTrace(problem.getException(), "        "));
        }
        return message.toString();
    }

    private String indentStackTrace(Exception ex, String indent) {
        return this.indentLines(this.printStackTrace(ex), indent);
    }

    private String printStackTrace(Exception ex) {
        StringWriter stackTrace = new StringWriter();
        PrintWriter printer = new PrintWriter(stackTrace);
        ex.printStackTrace(printer);
        return stackTrace.toString();
    }

    private String indentLines(String input, String indent) {
        StringWriter indented = new StringWriter();
        PrintWriter writer = new PrintWriter(indented);
        BufferedReader reader = new BufferedReader(new StringReader(input));
        reader.lines().forEach(line -> writer.println(indent + line));
        return indented.toString();
    }

    private DefaultProfileSelector createProfileSelector() {
        DefaultProfileSelector selector = new DefaultProfileSelector();
        selector.addProfileActivator((ProfileActivator)new FileProfileActivator().setPathTranslator((PathTranslator)new DefaultPathTranslator()));
        selector.addProfileActivator((ProfileActivator)new JdkVersionProfileActivator());
        selector.addProfileActivator((ProfileActivator)new PropertyProfileActivator());
        selector.addProfileActivator((ProfileActivator)new OperatingSystemProfileActivator());
        return selector;
    }

    private List<Profile> createModelProfiles(List<org.apache.maven.settings.Profile> profiles) {
        ArrayList<Profile> modelProfiles = new ArrayList<Profile>();
        for (org.apache.maven.settings.Profile profile : profiles) {
            Profile modelProfile = new Profile();
            modelProfile.setId(profile.getId());
            if (profile.getActivation() != null) {
                modelProfile.setActivation(this.createModelActivation(profile.getActivation()));
            }
            modelProfiles.add(modelProfile);
        }
        return modelProfiles;
    }

    private org.apache.maven.model.Activation createModelActivation(Activation activation) {
        org.apache.maven.model.Activation modelActivation = new org.apache.maven.model.Activation();
        modelActivation.setActiveByDefault(activation.isActiveByDefault());
        if (activation.getFile() != null) {
            ActivationFile activationFile = new ActivationFile();
            activationFile.setExists(activation.getFile().getExists());
            activationFile.setMissing(activation.getFile().getMissing());
            modelActivation.setFile(activationFile);
        }
        modelActivation.setJdk(activation.getJdk());
        if (activation.getOs() != null) {
            ActivationOS os = new ActivationOS();
            os.setArch(activation.getOs().getArch());
            os.setFamily(activation.getOs().getFamily());
            os.setName(activation.getOs().getName());
            os.setVersion(activation.getOs().getVersion());
            modelActivation.setOs(os);
        }
        if (activation.getProperty() != null) {
            ActivationProperty property = new ActivationProperty();
            property.setName(activation.getProperty().getName());
            property.setValue(activation.getProperty().getValue());
            modelActivation.setProperty(property);
        }
        return modelActivation;
    }

    public boolean getOffline() {
        return this.offline;
    }

    public MirrorSelector getMirrorSelector() {
        return this.mirrorSelector;
    }

    public AuthenticationSelector getAuthenticationSelector() {
        return this.authenticationSelector;
    }

    public ProxySelector getProxySelector() {
        return this.proxySelector;
    }

    public String getLocalRepository() {
        return this.localRepository;
    }

    public List<org.apache.maven.settings.Profile> getActiveProfiles() {
        return this.activeProfiles;
    }
}

