/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.cli.compiler.maven;

import java.io.File;
import org.apache.maven.settings.Settings;
import org.apache.maven.settings.building.DefaultSettingsBuilderFactory;
import org.apache.maven.settings.building.DefaultSettingsBuildingRequest;
import org.apache.maven.settings.building.SettingsBuildingException;
import org.apache.maven.settings.building.SettingsBuildingRequest;
import org.apache.maven.settings.crypto.DefaultSettingsDecrypter;
import org.apache.maven.settings.crypto.DefaultSettingsDecryptionRequest;
import org.apache.maven.settings.crypto.SettingsDecrypter;
import org.apache.maven.settings.crypto.SettingsDecryptionRequest;
import org.apache.maven.settings.crypto.SettingsDecryptionResult;
import org.sonatype.plexus.components.sec.dispatcher.SecDispatcher;
import org.springframework.boot.cli.compiler.maven.MavenSettings;
import org.springframework.boot.cli.compiler.maven.MavenSettingsReader;
import org.springframework.boot.cli.util.Log;

public class MavenSettingsReader {
    private final String homeDir;

    public MavenSettingsReader() {
        this(System.getProperty("user.home"));
    }

    public MavenSettingsReader(String homeDir) {
        this.homeDir = homeDir;
    }

    public MavenSettings readSettings() {
        Settings settings = this.loadSettings();
        SettingsDecryptionResult decrypted = this.decryptSettings(settings);
        if (!decrypted.getProblems().isEmpty()) {
            Log.error((String)"Maven settings decryption failed. Some Maven repositories may be inaccessible");
        }
        return new MavenSettings(settings, decrypted);
    }

    private Settings loadSettings() {
        File settingsFile = new File(this.homeDir, ".m2/settings.xml");
        DefaultSettingsBuildingRequest request = new DefaultSettingsBuildingRequest();
        request.setUserSettingsFile(settingsFile);
        request.setSystemProperties(System.getProperties());
        try {
            return new DefaultSettingsBuilderFactory().newInstance().build((SettingsBuildingRequest)request).getEffectiveSettings();
        }
        catch (SettingsBuildingException ex) {
            throw new IllegalStateException("Failed to build settings from " + settingsFile, ex);
        }
    }

    private SettingsDecryptionResult decryptSettings(Settings settings) {
        DefaultSettingsDecryptionRequest request = new DefaultSettingsDecryptionRequest(settings);
        return this.createSettingsDecrypter().decrypt((SettingsDecryptionRequest)request);
    }

    private SettingsDecrypter createSettingsDecrypter() {
        return new DefaultSettingsDecrypter((SecDispatcher)new SpringBootSecDispatcher(this));
    }
}

