/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.devtools.tunnel.client;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousCloseException;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.WritableByteChannel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.boot.devtools.tunnel.client.TunnelClientListener;
import org.springframework.boot.devtools.tunnel.client.TunnelClientListeners;
import org.springframework.boot.devtools.tunnel.client.TunnelConnection;
import org.springframework.util.Assert;

public class TunnelClient
implements SmartInitializingSingleton {
    private static final int BUFFER_SIZE = 102400;
    private static final Log logger = LogFactory.getLog(TunnelClient.class);
    private final TunnelClientListeners listeners = new TunnelClientListeners();
    private final Object monitor = new Object();
    private final int listenPort;
    private final TunnelConnection tunnelConnection;
    private ServerThread serverThread;

    public TunnelClient(int listenPort, TunnelConnection tunnelConnection) {
        Assert.isTrue((listenPort >= 0 ? 1 : 0) != 0, (String)"ListenPort must be greater than or equal to 0");
        Assert.notNull((Object)tunnelConnection, (String)"TunnelConnection must not be null");
        this.listenPort = listenPort;
        this.tunnelConnection = tunnelConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterSingletonsInstantiated() {
        Object object = this.monitor;
        synchronized (object) {
            if (this.serverThread == null) {
                try {
                    this.start();
                }
                catch (IOException ex) {
                    throw new IllegalStateException(ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int start() throws IOException {
        Object object = this.monitor;
        synchronized (object) {
            Assert.state((this.serverThread == null ? 1 : 0) != 0, (String)"Server already started");
            ServerSocketChannel serverSocketChannel = ServerSocketChannel.open();
            serverSocketChannel.socket().bind(new InetSocketAddress(this.listenPort));
            int port = serverSocketChannel.socket().getLocalPort();
            logger.trace((Object)("Listening for TCP traffic to tunnel on port " + port));
            this.serverThread = new ServerThread(serverSocketChannel);
            this.serverThread.start();
            return port;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws IOException {
        Object object = this.monitor;
        synchronized (object) {
            if (this.serverThread != null) {
                this.serverThread.close();
                try {
                    this.serverThread.join(2000L);
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                }
                this.serverThread = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final ServerThread getServerThread() {
        Object object = this.monitor;
        synchronized (object) {
            return this.serverThread;
        }
    }

    public void addListener(TunnelClientListener listener) {
        this.listeners.addListener(listener);
    }

    public void removeListener(TunnelClientListener listener) {
        this.listeners.removeListener(listener);
    }

    private class SocketCloseable
    implements Closeable {
        private final SocketChannel socketChannel;
        private boolean closed = false;

        SocketCloseable(SocketChannel socketChannel) {
            this.socketChannel = socketChannel;
        }

        @Override
        public void close() throws IOException {
            if (!this.closed) {
                this.socketChannel.close();
                TunnelClient.this.listeners.fireCloseEvent(this.socketChannel);
                this.closed = true;
            }
        }
    }

    protected class ServerThread
    extends Thread {
        private final ServerSocketChannel serverSocketChannel;
        private boolean acceptConnections = true;

        public ServerThread(ServerSocketChannel serverSocketChannel) {
            this.serverSocketChannel = serverSocketChannel;
            this.setName("Tunnel Server");
            this.setDaemon(true);
        }

        public void close() throws IOException {
            logger.trace((Object)("Closing tunnel client on port " + this.serverSocketChannel.socket().getLocalPort()));
            this.serverSocketChannel.close();
            this.acceptConnections = false;
            this.interrupt();
        }

        @Override
        public void run() {
            block13: while (true) {
                try {
                    while (this.acceptConnections) {
                        try {
                            SocketChannel socket = this.serverSocketChannel.accept();
                            Throwable throwable = null;
                            try {
                                this.handleConnection(socket);
                                continue block13;
                            }
                            catch (Throwable throwable2) {
                                throwable = throwable2;
                                throw throwable2;
                            }
                            finally {
                                if (socket == null) continue block13;
                                if (throwable != null) {
                                    try {
                                        socket.close();
                                    }
                                    catch (Throwable throwable3) {
                                        throwable.addSuppressed(throwable3);
                                    }
                                    continue block13;
                                }
                                socket.close();
                                continue block13;
                            }
                        }
                        catch (AsynchronousCloseException socket) {
                        }
                    }
                    break;
                }
                catch (Exception ex) {
                    logger.trace((Object)"Unexpected exception from tunnel client", (Throwable)ex);
                    break;
                }
            }
        }

        private void handleConnection(SocketChannel socketChannel) throws Exception {
            SocketCloseable closeable = new SocketCloseable(socketChannel);
            TunnelClient.this.listeners.fireOpenEvent(socketChannel);
            try (WritableByteChannel outputChannel = TunnelClient.this.tunnelConnection.open(socketChannel, closeable);){
                logger.trace((Object)("Accepted connection to tunnel client from " + socketChannel.socket().getRemoteSocketAddress()));
                while (true) {
                    ByteBuffer buffer;
                    int amountRead;
                    if ((amountRead = socketChannel.read(buffer = ByteBuffer.allocate(102400))) == -1) {
                        outputChannel.close();
                        return;
                    }
                    if (amountRead <= 0) continue;
                    buffer.flip();
                    outputChannel.write(buffer);
                }
            }
        }

        protected void stopAcceptingConnections() {
            this.acceptConnections = false;
        }
    }
}

