/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.devtools.env;

import java.io.File;
import java.io.IOException;
import java.util.Properties;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.devtools.DevToolsEnablementDeducer;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.PropertiesPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PropertiesLoaderUtils;
import org.springframework.util.StringUtils;

public class DevToolsHomePropertiesPostProcessor
implements EnvironmentPostProcessor {
    private static final String FILE_NAME = ".spring-boot-devtools.properties";

    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        if (DevToolsEnablementDeducer.shouldEnable(Thread.currentThread())) {
            File propertyFile;
            File home = this.getHomeFolder();
            File file = propertyFile = home != null ? new File(home, FILE_NAME) : null;
            if (propertyFile != null && propertyFile.exists() && propertyFile.isFile()) {
                FileSystemResource resource = new FileSystemResource(propertyFile);
                try {
                    Properties properties = PropertiesLoaderUtils.loadProperties((Resource)resource);
                    environment.getPropertySources().addFirst((PropertySource)new PropertiesPropertySource("devtools-local", properties));
                }
                catch (IOException ex) {
                    throw new IllegalStateException("Unable to load .spring-boot-devtools.properties", ex);
                }
            }
        }
    }

    protected File getHomeFolder() {
        String home = System.getProperty("user.home");
        if (StringUtils.hasLength((String)home)) {
            return new File(home);
        }
        return null;
    }
}

