/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.loader;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.Manifest;
import org.springframework.boot.loader.Archive;
import org.springframework.boot.loader.jar.JarEntryFilter;
import org.springframework.boot.loader.jar.RandomAccessJarFile;

public class JarFileArchive
implements Archive {
    private final RandomAccessJarFile jarFile;
    private final List<Archive.Entry> entries;

    public JarFileArchive(File file) throws IOException {
        this(new RandomAccessJarFile(file, new JarEntryFilter[0]));
    }

    public JarFileArchive(RandomAccessJarFile jarFile) {
        this.jarFile = jarFile;
        ArrayList<JarFileEntry> jarFileEntries = new ArrayList<JarFileEntry>();
        Enumeration<JarEntry> entries = jarFile.entries();
        while (entries.hasMoreElements()) {
            jarFileEntries.add(new JarFileEntry(entries.nextElement()));
        }
        this.entries = Collections.unmodifiableList(jarFileEntries);
    }

    @Override
    public Manifest getManifest() throws IOException {
        return this.jarFile.getManifest();
    }

    @Override
    public Iterable<Archive.Entry> getEntries() {
        return this.entries;
    }

    @Override
    public URL getUrl() throws MalformedURLException {
        return this.jarFile.getUrl();
    }

    @Override
    public Archive getNestedArchive(Archive.Entry entry) throws IOException {
        JarEntry jarEntry = ((JarFileEntry)entry).getJarEntry();
        RandomAccessJarFile jarFile = this.jarFile.getNestedJarFile(jarEntry, new JarEntryFilter[0]);
        return new JarFileArchive(jarFile);
    }

    @Override
    public Archive getFilteredArchive(final Archive.EntryFilter filter) throws IOException {
        RandomAccessJarFile filteredJar = this.jarFile.getFilteredJarFile(new JarEntryFilter(){

            @Override
            public String apply(String name, JarEntry entry) {
                return filter.apply(name, new JarFileEntry(entry));
            }
        });
        return new JarFileArchive(filteredJar);
    }

    private static class JarFileEntry
    implements Archive.Entry {
        private final JarEntry jarEntry;

        public JarFileEntry(JarEntry jarEntry) {
            this.jarEntry = jarEntry;
        }

        public JarEntry getJarEntry() {
            return this.jarEntry;
        }

        @Override
        public boolean isDirectory() {
            return this.jarEntry.isDirectory();
        }

        @Override
        public String getName() {
            return this.jarEntry.getName();
        }
    }
}

