/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.loader;

import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import org.springframework.boot.loader.jar.RandomAccessJarFile;

public class LaunchedURLClassLoader
extends URLClassLoader {
    public LaunchedURLClassLoader(URL[] urls, ClassLoader parent) {
        super(urls, parent);
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        String packageName;
        int lastDot = name.lastIndexOf(46);
        if (lastDot != -1 && this.getPackage(packageName = name.substring(0, lastDot)) == null) {
            try {
                this.definePackageForFindClass(name, packageName);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return super.findClass(name);
    }

    private void definePackageForFindClass(final String name, final String packageName) {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws ClassNotFoundException {
                    String path = name.replace('.', '/').concat(".class");
                    URL[] uRLArray = LaunchedURLClassLoader.this.getURLs();
                    int n = uRLArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        URL url = uRLArray[n2];
                        try {
                            RandomAccessJarFile jarFile;
                            if (url.getContent() instanceof RandomAccessJarFile && (jarFile = (RandomAccessJarFile)url.getContent()).getManifest() != null && jarFile.getJarEntry(path) != null) {
                                LaunchedURLClassLoader.this.definePackage(packageName, jarFile.getManifest(), url);
                                return null;
                            }
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        ++n2;
                    }
                    return null;
                }
            }, AccessController.getContext());
        }
        catch (PrivilegedActionException privilegedActionException) {
            // empty catch block
        }
    }
}

