/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.loader;

import java.io.File;
import java.lang.reflect.Constructor;
import java.net.URI;
import java.net.URL;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.springframework.boot.loader.Archive;
import org.springframework.boot.loader.ExplodedArchive;
import org.springframework.boot.loader.JarFileArchive;
import org.springframework.boot.loader.LaunchedURLClassLoader;

public abstract class Launcher {
    private Logger logger = Logger.getLogger(Launcher.class.getName());
    private static final String RUNNER_CLASS = String.valueOf(Launcher.class.getPackage().getName()) + ".MainMethodRunner";

    public void launch(String[] args) {
        try {
            this.launch(args, this.getClass().getProtectionDomain());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.exit(1);
        }
    }

    protected void launch(String[] args, ProtectionDomain protectionDomain) throws Exception {
        String path;
        CodeSource codeSource = protectionDomain.getCodeSource();
        URI location = codeSource == null ? null : codeSource.getLocation().toURI();
        String string = path = location == null ? null : location.getPath();
        if (path == null) {
            throw new IllegalStateException("Unable to determine code source archive");
        }
        File root = new File(path);
        if (!root.exists()) {
            throw new IllegalStateException("Unable to determine code source archive from " + root);
        }
        Archive archive = root.isDirectory() ? new ExplodedArchive(root) : new JarFileArchive(root);
        this.launch(args, archive);
    }

    protected void launch(String[] args, Archive archive) throws Exception {
        ArrayList<Archive> lib = new ArrayList<Archive>();
        for (Archive.Entry entry : archive.getEntries()) {
            if (!this.isNestedArchive(entry)) continue;
            this.logger.fine("Adding: " + entry.getName());
            lib.add(archive.getNestedArchive(entry));
        }
        this.logger.fine("Added " + lib.size() + " entries");
        this.postProcessLib(archive, lib);
        ClassLoader classLoader = this.createClassLoader(lib);
        this.launch(args, archive, classLoader);
    }

    protected abstract boolean isNestedArchive(Archive.Entry var1);

    protected void postProcessLib(Archive archive, List<Archive> lib) throws Exception {
    }

    protected ClassLoader createClassLoader(List<Archive> lib) throws Exception {
        URL[] urls = new URL[lib.size()];
        int i = 0;
        while (i < urls.length) {
            urls[i] = lib.get(i).getUrl();
            ++i;
        }
        return this.createClassLoader(urls);
    }

    protected ClassLoader createClassLoader(URL[] urls) throws Exception {
        return new LaunchedURLClassLoader(urls, this.getClass().getClassLoader().getParent());
    }

    protected void launch(String[] args, Archive archive, ClassLoader classLoader) throws Exception {
        String mainClass = this.getMainClass(archive);
        Runnable runner = this.createMainMethodRunner(mainClass, args, classLoader);
        Thread runnerThread = new Thread(runner);
        runnerThread.setContextClassLoader(classLoader);
        runnerThread.setName(Thread.currentThread().getName());
        runnerThread.start();
    }

    protected String getMainClass(Archive archive) throws Exception {
        String mainClass = archive.getManifest().getMainAttributes().getValue("Start-Class");
        if (mainClass == null) {
            throw new IllegalStateException("No 'Start-Class' manifest entry specified");
        }
        return mainClass;
    }

    protected Runnable createMainMethodRunner(String mainClass, String[] args, ClassLoader classLoader) throws Exception {
        Class<?> runnerClass = classLoader.loadClass(RUNNER_CLASS);
        Constructor<?> constructor = runnerClass.getConstructor(String.class, String[].class);
        return (Runnable)constructor.newInstance(mainClass, args);
    }
}

