/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.loader;

import java.io.IOException;
import java.util.List;
import org.springframework.boot.loader.Archive;
import org.springframework.boot.loader.Launcher;

public class WarLauncher
extends Launcher {
    @Override
    protected boolean isNestedArchive(Archive.Entry entry) {
        if (entry.isDirectory()) {
            return entry.getName().equals("WEB-INF/classes/");
        }
        return entry.getName().startsWith("WEB-INF/lib/") || entry.getName().startsWith("WEB-INF/lib-provided/");
    }

    @Override
    protected void postProcessLib(Archive archive, List<Archive> lib) throws Exception {
        lib.add(0, this.filterArchive(archive));
    }

    protected Archive filterArchive(Archive archive) throws IOException {
        return archive.getFilteredArchive(new Archive.EntryFilter(){

            @Override
            public String apply(String entryName, Archive.Entry entry) {
                if (entryName.startsWith("META-INF/") || entryName.startsWith("WEB-INF/")) {
                    return null;
                }
                return entryName;
            }
        });
    }

    public static void main(String[] args) {
        new WarLauncher().launch(args);
    }
}

