/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.loader.jar;

import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import java.util.zip.ZipEntry;
import org.springframework.boot.loader.data.RandomAccessData;
import org.springframework.boot.loader.data.RandomAccessDataFile;
import org.springframework.boot.loader.jar.JarEntryFilter;
import org.springframework.boot.loader.jar.RandomAccessDataZipEntry;
import org.springframework.boot.loader.jar.RandomAccessDataZipInputStream;

public class RandomAccessJarFile
extends JarFile {
    private final RandomAccessDataFile rootJarFile;
    private RandomAccessData data;
    private final String name;
    private final long size;
    private Map<String, JarEntry> entries = new LinkedHashMap<String, JarEntry>();
    private Manifest manifest;

    public RandomAccessJarFile(File file, JarEntryFilter ... filters) throws IOException {
        this(new RandomAccessDataFile(file), filters);
    }

    public RandomAccessJarFile(RandomAccessDataFile file, JarEntryFilter ... filters) throws IOException {
        this(file, file.getFile().getPath(), file, filters);
    }

    private RandomAccessJarFile(RandomAccessDataFile rootJarFile, String name, RandomAccessData data, JarEntryFilter ... filters) throws IOException {
        super(rootJarFile.getFile());
        this.rootJarFile = rootJarFile;
        this.name = name;
        this.data = data;
        this.size = data.getSize();
        RandomAccessDataZipInputStream inputStream = new RandomAccessDataZipInputStream(data);
        try {
            RandomAccessDataZipEntry zipEntry = inputStream.getNextEntry();
            while (zipEntry != null) {
                this.addJarEntry(zipEntry, filters);
                zipEntry = inputStream.getNextEntry();
            }
            this.manifest = this.findManifest();
            if (this.manifest != null) {
                for (JarEntry containedEntry : this.entries.values()) {
                    ((Entry)containedEntry).configure(this.manifest);
                }
            }
        }
        finally {
            inputStream.close();
        }
    }

    private void addJarEntry(RandomAccessDataZipEntry zipEntry, JarEntryFilter ... filters) {
        Entry jarEntry = new Entry(zipEntry);
        String name = zipEntry.getName();
        JarEntryFilter[] jarEntryFilterArray = filters;
        int n = filters.length;
        int n2 = 0;
        while (n2 < n) {
            JarEntryFilter filter = jarEntryFilterArray[n2];
            name = filter == null || name == null ? name : filter.apply(name, jarEntry);
            ++n2;
        }
        if (name != null) {
            jarEntry.setName(name);
            this.entries.put(name, jarEntry);
        }
    }

    private Manifest findManifest() throws IOException {
        ZipEntry manifestEntry = this.getEntry("META-INF/MANIFEST.MF");
        if (manifestEntry != null) {
            BufferedInputStream inputStream = new BufferedInputStream(this.getInputStream(manifestEntry));
            return new Manifest(inputStream);
        }
        return null;
    }

    protected final RandomAccessDataFile getRootJarFile() {
        return this.rootJarFile;
    }

    @Override
    public Manifest getManifest() throws IOException {
        return this.manifest;
    }

    @Override
    public Enumeration<JarEntry> entries() {
        return Collections.enumeration(this.entries.values());
    }

    @Override
    public JarEntry getJarEntry(String name) {
        return (JarEntry)this.getEntry(name);
    }

    @Override
    public ZipEntry getEntry(String name) {
        JarEntry entry = this.entries.get(name);
        if (entry == null && name != null && !name.endsWith("/")) {
            entry = this.entries.get(String.valueOf(name) + "/");
        }
        return entry;
    }

    @Override
    public synchronized InputStream getInputStream(ZipEntry ze) throws IOException {
        InputStream inputStream = this.getData(ze).getInputStream();
        if (ze.getMethod() == 8) {
            inputStream = new ZipInflaterInputStream(inputStream, (int)ze.getSize());
        }
        return inputStream;
    }

    public synchronized RandomAccessJarFile getNestedJarFile(ZipEntry ze, JarEntryFilter ... filters) throws IOException {
        if (ze == null) {
            throw new IllegalArgumentException("ZipEntry must not be null");
        }
        if (ze.isDirectory()) {
            return this.getNestedJarFileFromDirectoryEntry(ze, filters);
        }
        return this.getNestedJarFileFromFileEntry(ze, filters);
    }

    private RandomAccessJarFile getNestedJarFileFromDirectoryEntry(final ZipEntry entry, JarEntryFilter ... filters) throws IOException {
        final String name = entry.getName();
        JarEntryFilter[] filtersToUse = new JarEntryFilter[filters.length + 1];
        System.arraycopy(filters, 0, filtersToUse, 1, filters.length);
        filtersToUse[0] = new JarEntryFilter(){

            @Override
            public String apply(String entryName, JarEntry ze) {
                if (entryName.startsWith(name) && !entryName.equals(name)) {
                    return entryName.substring(entry.getName().length());
                }
                return null;
            }
        };
        return new RandomAccessJarFile(this.rootJarFile, String.valueOf(this.getName()) + "!/" + name.substring(0, name.length() - 1), this.data, filtersToUse);
    }

    private RandomAccessJarFile getNestedJarFileFromFileEntry(ZipEntry entry, JarEntryFilter ... filters) throws IOException {
        if (entry.getMethod() != 0) {
            throw new IllegalStateException("Unable to open nested compressed entry " + entry.getName());
        }
        return new RandomAccessJarFile(this.rootJarFile, String.valueOf(this.getName()) + "!/" + entry.getName(), this.getData(entry), filters);
    }

    public synchronized RandomAccessJarFile getFilteredJarFile(JarEntryFilter ... filters) throws IOException {
        return new RandomAccessJarFile(this.rootJarFile, this.getName(), this.data, filters);
    }

    private synchronized RandomAccessData getData(ZipEntry ze) throws IOException {
        if (!this.entries.containsValue(ze)) {
            throw new IllegalArgumentException("ZipEntry must be contained in this file");
        }
        return ((Entry)ze).getData();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int size() {
        return (int)this.size;
    }

    @Override
    public void close() throws IOException {
        this.rootJarFile.close();
    }

    public String toString() {
        return this.getName();
    }

    public URL getUrl() throws MalformedURLException {
        RandomAccessJarURLStreamHandler handler = new RandomAccessJarURLStreamHandler(this);
        return new URL("jar", "", -1, "file:" + this.getName() + "!/", handler);
    }

    private static class Entry
    extends JarEntry {
        private String name;
        private RandomAccessData entryData;
        private Attributes attributes;

        public Entry(RandomAccessDataZipEntry entry) {
            super(entry);
            this.entryData = entry.getData();
        }

        void configure(Manifest manifest) {
            this.attributes = manifest.getAttributes(this.getName());
        }

        void setName(String name) {
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name == null ? super.getName() : this.name;
        }

        @Override
        public Attributes getAttributes() throws IOException {
            return this.attributes;
        }

        public RandomAccessData getData() {
            return this.entryData;
        }
    }

    private static class RandomAccessJarURLConnection
    extends JarURLConnection {
        private RandomAccessJarFile jarFile;
        private JarEntry jarEntry;
        private String jarEntryName;
        private String contentType;

        protected RandomAccessJarURLConnection(URL url, RandomAccessJarFile jarFile) throws MalformedURLException {
            super(new URL("jar:file:" + jarFile.getRootJarFile().getFile().getPath() + "!/"));
            this.jarFile = jarFile;
            String spec = url.getFile();
            int separator = spec.lastIndexOf("!/");
            if (separator == -1) {
                throw new MalformedURLException("no !/ found in url spec:" + spec);
            }
            if (separator + 2 != spec.length()) {
                this.jarEntryName = spec.substring(separator + 2);
            }
        }

        @Override
        public void connect() throws IOException {
            if (this.jarEntryName != null) {
                this.jarEntry = this.jarFile.getJarEntry(this.jarEntryName);
                if (this.jarEntry == null) {
                    throw new FileNotFoundException("JAR entry " + this.jarEntryName + " not found in " + this.jarFile.getName());
                }
            }
            this.connected = true;
        }

        @Override
        public RandomAccessJarFile getJarFile() throws IOException {
            this.connect();
            return this.jarFile;
        }

        @Override
        public JarEntry getJarEntry() throws IOException {
            this.connect();
            return this.jarEntry;
        }

        @Override
        public InputStream getInputStream() throws IOException {
            this.connect();
            if (this.jarEntryName == null) {
                throw new IOException("no entry name specified");
            }
            return this.jarFile.getInputStream(this.jarEntry);
        }

        @Override
        public int getContentLength() {
            try {
                this.connect();
                return (int)(this.jarEntry == null ? (long)this.jarFile.size() : this.jarEntry.getSize());
            }
            catch (IOException ex) {
                return -1;
            }
        }

        @Override
        public Object getContent() throws IOException {
            this.connect();
            return this.jarEntry == null ? this.jarFile : super.getContent();
        }

        @Override
        public String getContentType() {
            if (this.contentType == null) {
                this.contentType = this.jarEntryName == null ? "x-java/jar" : null;
                this.contentType = this.contentType == null ? RandomAccessJarURLConnection.guessContentTypeFromName(this.jarEntryName) : this.contentType;
                this.contentType = this.contentType == null ? "content/unknown" : this.contentType;
            }
            return this.contentType;
        }
    }

    private static class RandomAccessJarURLStreamHandler
    extends URLStreamHandler {
        private RandomAccessJarFile jarFile;

        public RandomAccessJarURLStreamHandler(RandomAccessJarFile jarFile) {
            this.jarFile = jarFile;
        }

        @Override
        protected URLConnection openConnection(URL url) throws IOException {
            return new RandomAccessJarURLConnection(url, this.jarFile);
        }
    }

    private static class ZipInflaterInputStream
    extends InflaterInputStream {
        private boolean extraBytesWritten;
        private int available;

        public ZipInflaterInputStream(InputStream inputStream, int size) {
            super(inputStream, new Inflater(true), 512);
            this.available = size;
        }

        @Override
        public int available() throws IOException {
            if (this.available < 0) {
                return super.available();
            }
            return this.available;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int result = super.read(b, off, len);
            if (result != -1) {
                this.available -= result;
            }
            return result;
        }

        @Override
        protected void fill() throws IOException {
            try {
                super.fill();
            }
            catch (EOFException ex) {
                if (this.extraBytesWritten) {
                    throw ex;
                }
                this.len = 1;
                this.buf[0] = 0;
                this.extraBytesWritten = true;
                this.inf.setInput(this.buf, 0, this.len);
            }
        }
    }
}

