/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.loader.jar;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.springframework.boot.loader.jar.JarEntry;
import org.springframework.boot.loader.jar.JarEntryFilter;
import org.springframework.boot.loader.jar.JarFile;
import org.springframework.boot.loader.jar.JarURLConnection;

public class Handler
extends URLStreamHandler {
    private static final String FILE_PROTOCOL = "file:";
    private static final String SEPARATOR = "!/";
    private static final String[] FALLBACK_HANDLERS = new String[]{"sun.net.www.protocol.jar.Handler"};
    private static final Method OPEN_CONNECTION_METHOD;
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private final JarFile jarFile;
    private URLStreamHandler fallbackHandler;

    public Handler() {
        this(null);
    }

    public Handler(JarFile jarFile) {
        this.jarFile = jarFile;
    }

    @Override
    protected URLConnection openConnection(URL url) throws IOException {
        if (this.jarFile != null) {
            return new JarURLConnection(url, this.jarFile);
        }
        try {
            return new JarURLConnection(url, this.getJarFileFromUrl(url));
        }
        catch (Exception ex) {
            return this.openFallbackConnection(url, ex);
        }
    }

    private URLConnection openFallbackConnection(URL url, Exception reason) throws IOException {
        try {
            return this.openConnection(this.getFallbackHandler(), url);
        }
        catch (Exception ex) {
            this.logger.log(Level.WARNING, "Unable to open fallback handler", ex);
            if (reason instanceof IOException) {
                throw (IOException)reason;
            }
            if (reason instanceof RuntimeException) {
                throw (RuntimeException)reason;
            }
            throw new IllegalStateException(reason);
        }
    }

    private URLStreamHandler getFallbackHandler() {
        if (this.fallbackHandler != null) {
            return this.fallbackHandler;
        }
        for (String handlerClassName : FALLBACK_HANDLERS) {
            try {
                Class<?> handlerClass = Class.forName(handlerClassName);
                this.fallbackHandler = (URLStreamHandler)handlerClass.newInstance();
                return this.fallbackHandler;
            }
            catch (Exception ex) {
            }
        }
        throw new IllegalStateException("Unable to find fallback handler");
    }

    private URLConnection openConnection(URLStreamHandler handler, URL url) throws Exception {
        if (OPEN_CONNECTION_METHOD == null) {
            throw new IllegalStateException("Unable to invoke fallback open connection method");
        }
        OPEN_CONNECTION_METHOD.setAccessible(true);
        return (URLConnection)OPEN_CONNECTION_METHOD.invoke((Object)handler, url);
    }

    public JarFile getJarFileFromUrl(URL url) throws IOException {
        String spec = url.getFile();
        int separatorIndex = spec.indexOf(SEPARATOR);
        if (separatorIndex == -1) {
            throw new MalformedURLException("Jar URL does not contain !/ separator");
        }
        JarFile jar = null;
        while (separatorIndex != -1) {
            String name = spec.substring(0, separatorIndex);
            jar = jar == null ? this.getRootJarFile(name) : this.getNestedJarFile(jar, name);
            spec = spec.substring(separatorIndex + SEPARATOR.length());
            separatorIndex = spec.indexOf(SEPARATOR);
        }
        return jar;
    }

    private JarFile getRootJarFile(String name) throws IOException {
        try {
            if (!name.startsWith(FILE_PROTOCOL)) {
                throw new IllegalStateException("Not a file URL");
            }
            String path = name.substring(FILE_PROTOCOL.length());
            return new JarFile(new File(path), new JarEntryFilter[0]);
        }
        catch (Exception ex) {
            throw new IOException("Unable to open root Jar file '" + name + "'", ex);
        }
    }

    private JarFile getNestedJarFile(JarFile jarFile, String name) throws IOException {
        JarEntry jarEntry = jarFile.getJarEntry(name);
        if (jarEntry == null) {
            throw new IOException("Unable to find nested jar '" + name + "' from '" + jarFile + "'");
        }
        return jarFile.getNestedJarFile(jarEntry, new JarEntryFilter[0]);
    }

    static {
        Method method = null;
        try {
            method = URLStreamHandler.class.getDeclaredMethod("openConnection", URL.class);
        }
        catch (Exception exception) {
            // empty catch block
        }
        OPEN_CONNECTION_METHOD = method;
    }
}

