/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.context;

import java.lang.reflect.AnnotatedElement;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.web.client.LocalHostUriTemplateHandler;
import org.springframework.boot.test.web.client.TestRestTemplate;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.env.Environment;
import org.springframework.test.context.ContextCustomizer;
import org.springframework.test.context.MergedContextConfiguration;
import org.springframework.web.util.UriTemplateHandler;

class SpringBootTestContextCustomizer
implements ContextCustomizer {
    SpringBootTestContextCustomizer() {
    }

    public void customizeContext(ConfigurableApplicationContext context, MergedContextConfiguration mergedContextConfiguration) {
        SpringBootTest annotation = (SpringBootTest)AnnotatedElementUtils.getMergedAnnotation((AnnotatedElement)mergedContextConfiguration.getTestClass(), SpringBootTest.class);
        if (annotation.webEnvironment().isEmbedded()) {
            TestRestTemplate restTemplate = TestRestTemplateFactory.createRestTemplate((Environment)context.getEnvironment());
            context.getBeanFactory().registerSingleton("testRestTemplate", (Object)restTemplate);
        }
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    public boolean equals(Object obj) {
        return obj != null && obj.getClass() == this.getClass();
    }

    private static class TestRestTemplateFactory {
        private TestRestTemplateFactory() {
        }

        private static TestRestTemplate createRestTemplate(Environment environment) {
            TestRestTemplate template = new TestRestTemplate(new TestRestTemplate.HttpClientOption[0]);
            template.setUriTemplateHandler((UriTemplateHandler)new LocalHostUriTemplateHandler(environment));
            return template;
        }
    }
}

