/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.mock.mockito;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.springframework.boot.test.mock.mockito.Definition;
import org.springframework.boot.test.mock.mockito.MockBean;
import org.springframework.boot.test.mock.mockito.MockBeans;
import org.springframework.boot.test.mock.mockito.MockDefinition;
import org.springframework.boot.test.mock.mockito.SpyBean;
import org.springframework.boot.test.mock.mockito.SpyBeans;
import org.springframework.boot.test.mock.mockito.SpyDefinition;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

class DefinitionsParser {
    private final Set<Definition> definitions = new LinkedHashSet<Definition>();
    private final Map<Definition, Field> definitionFields = new LinkedHashMap<Definition, Field>();

    DefinitionsParser() {
        this(Collections.emptySet());
    }

    DefinitionsParser(Collection<? extends Definition> existing) {
        if (existing != null) {
            this.definitions.addAll(existing);
        }
    }

    public void parse(Class<?> source) {
        this.parseElement(source);
        ReflectionUtils.doWithFields(source, (ReflectionUtils.FieldCallback)new ReflectionUtils.FieldCallback(){

            public void doWith(Field field) throws IllegalArgumentException, IllegalAccessException {
                DefinitionsParser.this.parseElement(field);
            }
        });
    }

    private void parseElement(AnnotatedElement element) {
        for (Annotation annotation : AnnotationUtils.getRepeatableAnnotations((AnnotatedElement)element, MockBean.class, MockBeans.class)) {
            this.parseMockBeanAnnotation((MockBean)annotation, element);
        }
        for (Annotation annotation : AnnotationUtils.getRepeatableAnnotations((AnnotatedElement)element, SpyBean.class, SpyBeans.class)) {
            this.parseSpyBeanAnnotation((SpyBean)annotation, element);
        }
    }

    private void parseMockBeanAnnotation(MockBean annotation, AnnotatedElement element) {
        Set<Class<?>> classesToMock = this.getOrDeduceClasses(element, annotation.value());
        Assert.state((!classesToMock.isEmpty() ? 1 : 0) != 0, (String)("Unable to deduce class to mock from " + element));
        if (StringUtils.hasLength((String)annotation.name())) {
            Assert.state((classesToMock.size() == 1 ? 1 : 0) != 0, (String)"The name attribute can only be used when mocking a single class");
        }
        for (Class<?> classToMock : classesToMock) {
            MockDefinition definition = new MockDefinition(annotation.name(), classToMock, annotation.extraInterfaces(), annotation.answer(), annotation.serializable(), annotation.reset());
            this.addDefinition(element, definition, "mock");
        }
    }

    private void parseSpyBeanAnnotation(SpyBean annotation, AnnotatedElement element) {
        Set<Class<?>> classesToSpy = this.getOrDeduceClasses(element, annotation.value());
        Assert.state((!classesToSpy.isEmpty() ? 1 : 0) != 0, (String)("Unable to deduce class to spy from " + element));
        if (StringUtils.hasLength((String)annotation.name())) {
            Assert.state((classesToSpy.size() == 1 ? 1 : 0) != 0, (String)"The name attribute can only be used when spying a single class");
        }
        for (Class<?> classToSpy : classesToSpy) {
            SpyDefinition definition = new SpyDefinition(annotation.name(), classToSpy, annotation.reset());
            this.addDefinition(element, definition, "spy");
        }
    }

    private void addDefinition(AnnotatedElement element, Definition definition, String type) {
        boolean isNewDefinition = this.definitions.add(definition);
        Assert.state((boolean)isNewDefinition, (String)("Duplicate " + type + " definition " + definition));
        if (element instanceof Field) {
            Field field = (Field)element;
            this.definitionFields.put(definition, field);
        }
    }

    private Set<Class<?>> getOrDeduceClasses(AnnotatedElement element, Class<?>[] value) {
        LinkedHashSet classes = new LinkedHashSet();
        classes.addAll(Arrays.asList(value));
        if (classes.isEmpty() && element instanceof Field) {
            classes.add(((Field)element).getType());
        }
        return classes;
    }

    public Set<Definition> getDefinitions() {
        return Collections.unmodifiableSet(this.definitions);
    }

    public Field getField(Definition definition) {
        return this.definitionFields.get(definition);
    }
}

