/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.mock.mockito;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.springframework.beans.BeansException;
import org.springframework.beans.PropertyValues;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.ConstructorArgumentValues;
import org.springframework.beans.factory.config.InstantiationAwareBeanPostProcessorAdapter;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanNameGenerator;
import org.springframework.beans.factory.support.DefaultBeanNameGenerator;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.boot.test.mock.mockito.Definition;
import org.springframework.boot.test.mock.mockito.DefinitionsParser;
import org.springframework.boot.test.mock.mockito.MockDefinition;
import org.springframework.boot.test.mock.mockito.SpyDefinition;
import org.springframework.context.annotation.ConfigurationClassPostProcessor;
import org.springframework.core.Conventions;
import org.springframework.core.Ordered;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public class MockitoPostProcessor
extends InstantiationAwareBeanPostProcessorAdapter
implements BeanClassLoaderAware,
BeanFactoryAware,
BeanFactoryPostProcessor,
BeanPostProcessor,
Ordered {
    private static final String BEAN_NAME = MockitoPostProcessor.class.getName();
    private static final String CONFIGURATION_CLASS_ATTRIBUTE = Conventions.getQualifiedAttributeName(ConfigurationClassPostProcessor.class, (String)"configurationClass");
    private final Set<Definition> definitions;
    private ClassLoader classLoader;
    private BeanFactory beanFactory;
    private final BeanNameGenerator beanNameGenerator = new DefaultBeanNameGenerator();
    private Map<Definition, String> beanNameRegistry = new HashMap<Definition, String>();
    private Map<Field, String> fieldRegistry = new HashMap<Field, String>();
    private Map<String, SpyDefinition> spies = new HashMap<String, SpyDefinition>();

    public MockitoPostProcessor(Set<Definition> definitions) {
        this.definitions = definitions;
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        Assert.isInstanceOf(ConfigurableListableBeanFactory.class, (Object)beanFactory, (String)"Mock beans can only be used with a ConfigurableListableBeanFactory");
        this.beanFactory = beanFactory;
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        Assert.isInstanceOf(BeanDefinitionRegistry.class, (Object)beanFactory, (String)"@RegisterMocks can only be used on bean factories that implement BeanDefinitionRegistry");
        this.postProcessBeanFactory(beanFactory, (BeanDefinitionRegistry)beanFactory);
    }

    private void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory, BeanDefinitionRegistry registry) {
        DefinitionsParser parser = new DefinitionsParser(this.definitions);
        for (Class<?> configurationClass : this.getConfigurationClasses(beanFactory)) {
            parser.parse(configurationClass);
        }
        Set<Definition> definitions = parser.getDefinitions();
        for (Definition definition : definitions) {
            Field field = parser.getField(definition);
            this.register(beanFactory, registry, definition, field);
        }
    }

    private Set<Class<?>> getConfigurationClasses(ConfigurableListableBeanFactory beanFactory) {
        LinkedHashSet configurationClasses = new LinkedHashSet();
        for (BeanDefinition beanDefinition : this.getConfigurationBeanDefinitions(beanFactory).values()) {
            configurationClasses.add(ClassUtils.resolveClassName((String)beanDefinition.getBeanClassName(), (ClassLoader)this.classLoader));
        }
        return configurationClasses;
    }

    private Map<String, BeanDefinition> getConfigurationBeanDefinitions(ConfigurableListableBeanFactory beanFactory) {
        LinkedHashMap<String, BeanDefinition> definitions = new LinkedHashMap<String, BeanDefinition>();
        for (String beanName : beanFactory.getBeanDefinitionNames()) {
            BeanDefinition definition = beanFactory.getBeanDefinition(beanName);
            if (definition.getAttribute(CONFIGURATION_CLASS_ATTRIBUTE) == null) continue;
            definitions.put(beanName, definition);
        }
        return definitions;
    }

    private void register(ConfigurableListableBeanFactory beanFactory, BeanDefinitionRegistry registry, Definition definition, Field field) {
        if (definition instanceof MockDefinition) {
            this.registerMock(beanFactory, registry, (MockDefinition)definition, field);
        } else if (definition instanceof SpyDefinition) {
            this.registerSpy(beanFactory, registry, (SpyDefinition)definition, field);
        }
    }

    private void registerMock(ConfigurableListableBeanFactory beanFactory, BeanDefinitionRegistry registry, MockDefinition definition, Field field) {
        RootBeanDefinition beanDefinition = this.createBeanDefinition(definition);
        String name = this.getBeanName(beanFactory, registry, definition, beanDefinition);
        beanDefinition.getConstructorArgumentValues().addIndexedArgumentValue(1, (Object)name);
        registry.registerBeanDefinition(name, (BeanDefinition)beanDefinition);
        this.beanNameRegistry.put(definition, name);
        if (field != null) {
            this.fieldRegistry.put(field, name);
        }
    }

    private RootBeanDefinition createBeanDefinition(MockDefinition mockDefinition) {
        RootBeanDefinition definition = new RootBeanDefinition(mockDefinition.getClassToMock());
        definition.setTargetType(mockDefinition.getClassToMock());
        definition.setFactoryBeanName(BEAN_NAME);
        definition.setFactoryMethodName("createMock");
        definition.getConstructorArgumentValues().addIndexedArgumentValue(0, (Object)mockDefinition);
        return definition;
    }

    protected final Object createMock(MockDefinition mockDefinition, String name) {
        return mockDefinition.createMock(name + " bean");
    }

    private String getBeanName(ConfigurableListableBeanFactory beanFactory, BeanDefinitionRegistry registry, MockDefinition mockDefinition, RootBeanDefinition beanDefinition) {
        if (StringUtils.hasLength((String)mockDefinition.getName())) {
            return mockDefinition.getName();
        }
        Object[] existingBeans = beanFactory.getBeanNamesForType(mockDefinition.getClassToMock());
        if (ObjectUtils.isEmpty((Object[])existingBeans)) {
            return this.beanNameGenerator.generateBeanName((BeanDefinition)beanDefinition, registry);
        }
        if (existingBeans.length == 1) {
            return existingBeans[0];
        }
        throw new IllegalStateException("Unable to register mock bean " + mockDefinition.getClassToMock().getName() + " expected a single existing bean to replace but found " + new TreeSet<Object>(Arrays.asList(existingBeans)));
    }

    private void registerSpy(ConfigurableListableBeanFactory beanFactory, BeanDefinitionRegistry registry, SpyDefinition spyDefinition, Field field) {
        Object[] existingBeans = beanFactory.getBeanNamesForType(spyDefinition.getClassToSpy());
        if (ObjectUtils.isEmpty((Object[])existingBeans)) {
            this.createSpy(registry, spyDefinition, field);
        } else {
            this.registerSpies(spyDefinition, field, (String[])existingBeans);
        }
    }

    private void createSpy(BeanDefinitionRegistry registry, SpyDefinition spyDefinition, Field field) {
        RootBeanDefinition beanDefinition = new RootBeanDefinition(spyDefinition.getClassToSpy());
        String beanName = this.beanNameGenerator.generateBeanName((BeanDefinition)beanDefinition, registry);
        registry.registerBeanDefinition(beanName, (BeanDefinition)beanDefinition);
        this.registerSpy(spyDefinition, field, beanName);
    }

    private void registerSpies(SpyDefinition spyDefinition, Field field, String[] existingBeans) {
        if (field != null) {
            Assert.state((field == null || existingBeans.length == 1 ? 1 : 0) != 0, (String)("Unable to register spy bean " + spyDefinition.getClassToSpy().getName() + " expected a single existing bean to replace but found " + new TreeSet<String>(Arrays.asList(existingBeans))));
        }
        for (String beanName : existingBeans) {
            this.registerSpy(spyDefinition, field, beanName);
        }
    }

    private void registerSpy(SpyDefinition spyDefinition, Field field, String beanName) {
        this.spies.put(beanName, spyDefinition);
        this.beanNameRegistry.put(spyDefinition, beanName);
        if (field != null) {
            this.fieldRegistry.put(field, beanName);
        }
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        SpyDefinition spyDefinition = this.spies.get(beanName);
        if (spyDefinition != null) {
            bean = spyDefinition.createSpy(beanName, bean);
        }
        return bean;
    }

    public PropertyValues postProcessPropertyValues(PropertyValues pvs, PropertyDescriptor[] pds, final Object bean, String beanName) throws BeansException {
        ReflectionUtils.doWithFields(bean.getClass(), (ReflectionUtils.FieldCallback)new ReflectionUtils.FieldCallback(){

            public void doWith(Field field) throws IllegalArgumentException, IllegalAccessException {
                MockitoPostProcessor.this.postProcessField(bean, field);
            }
        });
        return pvs;
    }

    private void postProcessField(Object bean, Field field) {
        String beanName = this.fieldRegistry.get(field);
        if (StringUtils.hasLength((String)beanName)) {
            this.inject(field, bean, beanName);
        }
    }

    void inject(Field field, Object target, Definition definition) {
        String beanName = this.beanNameRegistry.get(definition);
        Assert.state((boolean)StringUtils.hasLength((String)beanName), (String)("No bean found for definition " + definition));
        this.inject(field, target, beanName);
    }

    private void inject(Field field, Object target, String beanName) {
        try {
            field.setAccessible(true);
            Assert.state((ReflectionUtils.getField((Field)field, (Object)target) == null ? 1 : 0) != 0, (String)("The field " + field + " cannot have an existing value"));
            Object bean = this.beanFactory.getBean(beanName, field.getType());
            ReflectionUtils.setField((Field)field, (Object)target, (Object)bean);
        }
        catch (Throwable ex) {
            throw new BeanCreationException("Could not inject field: " + field, ex);
        }
    }

    public int getOrder() {
        return 0x7FFFFFF5;
    }

    public static void register(BeanDefinitionRegistry registry) {
        MockitoPostProcessor.register(registry, null);
    }

    public static void register(BeanDefinitionRegistry registry, Set<Definition> definitions) {
        MockitoPostProcessor.register(registry, MockitoPostProcessor.class, definitions);
    }

    public static void register(BeanDefinitionRegistry registry, Class<? extends MockitoPostProcessor> postProcessor, Set<Definition> definitions) {
        BeanDefinition definition = MockitoPostProcessor.getOrAddBeanDefinition(registry, postProcessor);
        ConstructorArgumentValues.ValueHolder constructorArg = definition.getConstructorArgumentValues().getIndexedArgumentValue(0, Set.class);
        Set existing = (Set)constructorArg.getValue();
        if (definitions != null) {
            existing.addAll(definitions);
        }
    }

    private static BeanDefinition getOrAddBeanDefinition(BeanDefinitionRegistry registry, Class<? extends MockitoPostProcessor> postProcessor) {
        if (!registry.containsBeanDefinition(BEAN_NAME)) {
            RootBeanDefinition definition = new RootBeanDefinition(postProcessor);
            definition.setRole(2);
            ConstructorArgumentValues constructorArguments = definition.getConstructorArgumentValues();
            constructorArguments.addIndexedArgumentValue(0, new LinkedHashSet());
            registry.registerBeanDefinition(BEAN_NAME, (BeanDefinition)definition);
            return definition;
        }
        return registry.getBeanDefinition(BEAN_NAME);
    }
}

