/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.mock.mockito;

import org.mockito.Mockito;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.boot.test.mock.mockito.MockReset;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.test.context.TestContext;
import org.springframework.test.context.support.AbstractTestExecutionListener;

public class ResetMocksTestExecutionListener
extends AbstractTestExecutionListener {
    public void beforeTestMethod(TestContext testContext) throws Exception {
        this.resetMocks(testContext.getApplicationContext(), MockReset.BEFORE);
    }

    public void afterTestMethod(TestContext testContext) throws Exception {
        this.resetMocks(testContext.getApplicationContext(), MockReset.AFTER);
    }

    private void resetMocks(ApplicationContext applicationContext, MockReset reset) {
        if (applicationContext instanceof ConfigurableApplicationContext) {
            this.resetMocks((ConfigurableApplicationContext)applicationContext, reset);
        }
    }

    private void resetMocks(ConfigurableApplicationContext applicationContext, MockReset reset) {
        String[] names;
        ConfigurableListableBeanFactory beanFactory = applicationContext.getBeanFactory();
        for (String name : names = beanFactory.getBeanDefinitionNames()) {
            Object bean;
            BeanDefinition definition = beanFactory.getBeanDefinition(name);
            if (!"".equals(definition.getScope()) || !reset.equals((Object)MockReset.get(bean = beanFactory.getBean(name)))) continue;
            Mockito.reset((Object[])new Object[]{bean});
        }
        if (applicationContext.getParent() != null) {
            this.resetMocks(applicationContext.getParent(), reset);
        }
    }
}

