/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.mock.mockito;

import org.mockito.MockSettings;
import org.mockito.Mockito;
import org.mockito.internal.util.MockUtil;
import org.springframework.boot.test.mock.mockito.Definition;
import org.springframework.boot.test.mock.mockito.MockReset;
import org.springframework.core.style.ToStringCreator;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

class SpyDefinition
extends Definition {
    private MockUtil mockUtil = new MockUtil();
    private static final int MULTIPLIER = 31;
    private final Class<?> classToSpy;

    SpyDefinition(String name, Class<?> classToSpy, MockReset reset) {
        super(name, reset);
        Assert.notNull(classToSpy, (String)"ClassToSpy must not be null");
        this.classToSpy = classToSpy;
    }

    public Class<?> getClassToSpy() {
        return this.classToSpy;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + ObjectUtils.nullSafeHashCode(this.classToSpy);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        SpyDefinition other = (SpyDefinition)obj;
        boolean result = super.equals(obj);
        return result &= ObjectUtils.nullSafeEquals(this.classToSpy, other.classToSpy);
    }

    public String toString() {
        return new ToStringCreator((Object)this).append("name", (Object)this.getName()).append("classToSpy", this.classToSpy).append("reset", (Object)this.getReset()).toString();
    }

    public <T> T createSpy(Object instance) {
        return this.createSpy(this.getName(), instance);
    }

    public <T> T createSpy(String name, Object instance) {
        Assert.notNull((Object)instance, (String)"Instance must not be null");
        Assert.isInstanceOf(this.classToSpy, (Object)instance);
        if (this.mockUtil.isSpy(instance)) {
            return (T)instance;
        }
        MockSettings settings = MockReset.withSettings(this.getReset());
        if (StringUtils.hasLength((String)name)) {
            settings.name(name);
        }
        settings.spiedInstance(instance);
        settings.defaultAnswer(Mockito.CALLS_REAL_METHODS);
        return (T)Mockito.mock(instance.getClass(), (MockSettings)settings);
    }
}

