/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.context;

import javax.servlet.ServletContext;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.test.web.client.TestRestTemplate;
import org.springframework.boot.web.embedded.tomcat.TomcatServletWebServerFactory;
import org.springframework.boot.web.server.LocalServerPort;
import org.springframework.boot.web.servlet.server.ServletWebServerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.support.PropertySourcesPlaceholderConfigurer;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;
import org.springframework.web.servlet.DispatcherServlet;

public abstract class AbstractSpringBootTestWebServerWebEnvironmentTests {
    @LocalServerPort
    private int port = 0;
    @Value(value="${value}")
    private int value = 0;
    @Autowired
    private WebApplicationContext context;
    @Autowired
    private ServletContext servletContext;
    @Autowired
    private TestRestTemplate restTemplate;

    public WebApplicationContext getContext() {
        return this.context;
    }

    public TestRestTemplate getRestTemplate() {
        return this.restTemplate;
    }

    @Test
    public void runAndTestHttpEndpoint() {
        Assertions.assertThat((int)this.port).isNotEqualTo(8080).isNotEqualTo(0);
        String body = (String)new RestTemplate().getForObject("http://localhost:" + this.port + "/", String.class, new Object[0]);
        Assertions.assertThat((String)body).isEqualTo((Object)"Hello World");
    }

    @Test
    public void injectTestRestTemplate() {
        String body = (String)this.restTemplate.getForObject("/", String.class, new Object[0]);
        Assertions.assertThat((String)body).isEqualTo((Object)"Hello World");
    }

    @Test
    public void annotationAttributesOverridePropertiesFile() {
        Assertions.assertThat((int)this.value).isEqualTo(123);
    }

    @Test
    public void validateWebApplicationContextIsSet() {
        Assertions.assertThat((Object)this.context).isSameAs((Object)WebApplicationContextUtils.getWebApplicationContext((ServletContext)this.servletContext));
    }

    protected static abstract class AbstractConfig {
        @Value(value="${server.port:8080}")
        private int port = 8080;

        protected AbstractConfig() {
        }

        @Bean
        public DispatcherServlet dispatcherServlet() {
            return new DispatcherServlet();
        }

        @Bean
        public ServletWebServerFactory webServerFactory() {
            TomcatServletWebServerFactory factory = new TomcatServletWebServerFactory();
            factory.setPort(this.port);
            return factory;
        }

        @Bean
        public static PropertySourcesPlaceholderConfigurer propertyPlaceholder() {
            return new PropertySourcesPlaceholderConfigurer();
        }

        @RequestMapping(value={"/"})
        public String home() {
            return "Hello World";
        }
    }
}

